"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamsRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _default_api_types = require("../../types/default_api_types");
var _create_datasets_quality_server_route = require("../create_datasets_quality_server_route");
var _services = require("../../services");
var _get_data_stream_details = require("./get_data_stream_details");
var _get_data_streams = require("./get_data_streams");
var _get_data_streams_stats = require("./get_data_streams_stats");
var _get_degraded_docs = require("./get_degraded_docs");
var _get_non_aggregatable_data_streams = require("./get_non_aggregatable_data_streams");
var _get_degraded_fields = require("./get_degraded_fields");
var _get_degraded_field_values = require("./get_degraded_field_values");
var _get_degraded_field_analysis = require("./get_degraded_field_analysis");
var _get_data_streams_metering_stats = require("./get_data_streams_metering_stats");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/stats',
  params: t.type({
    query: t.intersection([t.type({
      types: _default_api_types.typesRt
    }), t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const coreContext = await context.core;
    const isServerless = (await getEsCapabilities()).serverless;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const esClientAsSecondaryAuthUser = coreContext.elasticsearch.client.asSecondaryAuthUser;
    const {
      dataStreams,
      datasetUserPrivileges
    } = await (0, _get_data_streams.getDataStreams)({
      esClient,
      ...params.query,
      uncategorisedOnly: false
    });
    const privilegedDataStreams = dataStreams.filter(dataStream => {
      return dataStream.userPrivileges.canMonitor;
    });
    const dataStreamsStats = isServerless ? await (0, _get_data_streams_metering_stats.getDataStreamsMeteringStats)({
      esClient: esClientAsSecondaryAuthUser,
      dataStreams: privilegedDataStreams.map(stream => stream.name)
    }) : await (0, _get_data_streams_stats.getDataStreamsStats)({
      esClient,
      dataStreams: privilegedDataStreams.map(stream => stream.name)
    });
    return {
      datasetUserPrivileges,
      dataStreamsStats: dataStreams.map(dataStream => {
        var _dataStreamsStats$dat, _dataStreamsStats$dat2, _dataStreamsStats$dat3;
        dataStream.size = (_dataStreamsStats$dat = dataStreamsStats[dataStream.name]) === null || _dataStreamsStats$dat === void 0 ? void 0 : _dataStreamsStats$dat.size;
        dataStream.sizeBytes = (_dataStreamsStats$dat2 = dataStreamsStats[dataStream.name]) === null || _dataStreamsStats$dat2 === void 0 ? void 0 : _dataStreamsStats$dat2.sizeBytes;
        dataStream.totalDocs = (_dataStreamsStats$dat3 = dataStreamsStats[dataStream.name]) === null || _dataStreamsStats$dat3 === void 0 ? void 0 : _dataStreamsStats$dat3.totalDocs;
        return dataStream;
      })
    };
  }
});
const degradedDocsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/degraded_docs',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.typeRt, t.partial({
      datasetQuery: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    await _services.datasetQualityPrivileges.throwIfCannotReadDataset(esClient, params.query.type, params.query.datasetQuery);
    const degradedDocs = await (0, _get_degraded_docs.getDegradedDocsPaginated)({
      esClient,
      ...params.query
    });
    return {
      degradedDocs
    };
  }
});
const nonAggregatableDatasetsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/non_aggregatable',
  params: t.type({
    query: t.intersection([_default_api_types.rangeRt, t.type({
      types: _default_api_types.typesRt
    }), t.partial({
      dataStream: t.string
    })])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    return await (0, _get_non_aggregatable_data_streams.getNonAggregatableDataStreams)({
      esClient,
      ...params.query
    });
  }
});
const nonAggregatableDatasetRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/non_aggregatable',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: t.intersection([_default_api_types.rangeRt, _default_api_types.typeRt])
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    await _services.datasetQualityPrivileges.throwIfCannotReadDataset(esClient, params.query.type);
    return await (0, _get_non_aggregatable_data_streams.getNonAggregatableDataStreams)({
      esClient,
      ...params.query,
      types: [params.query.type]
    });
  }
});
const degradedFieldsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/degraded_fields',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const {
      dataStream
    } = params.path;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    return await (0, _get_degraded_fields.getDegradedFields)({
      esClient,
      dataStream,
      ...params.query
    });
  }
});
const degradedFieldValuesRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/degraded_field/{degradedField}/values',
  params: t.type({
    path: t.type({
      dataStream: t.string,
      degradedField: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const {
      dataStream,
      degradedField
    } = params.path;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    return await (0, _get_degraded_field_values.getDegradedFieldValues)({
      esClient,
      dataStream,
      degradedField
    });
  }
});
const dataStreamSettingsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/settings',
  params: t.type({
    path: t.type({
      dataStream: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const {
      dataStream
    } = params.path;
    const coreContext = await context.core;

    // Query datastreams as the current user as the Kibana internal user may not have all the required permissions
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const dataStreamSettings = await (0, _get_data_stream_details.getDataStreamSettings)({
      esClient,
      dataStream
    });
    return dataStreamSettings;
  }
});
const dataStreamDetailsRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/details',
  params: t.type({
    path: t.type({
      dataStream: t.string
    }),
    query: _default_api_types.rangeRt
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params,
      getEsCapabilities
    } = resources;
    const {
      dataStream
    } = params.path;
    const {
      start,
      end
    } = params.query;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client;
    const isServerless = (await getEsCapabilities()).serverless;
    const dataStreamDetails = await (0, _get_data_stream_details.getDataStreamDetails)({
      esClient,
      dataStream,
      start,
      end,
      isServerless
    });
    return dataStreamDetails;
  }
});
const analyzeDegradedFieldRoute = (0, _create_datasets_quality_server_route.createDatasetQualityServerRoute)({
  endpoint: 'GET /internal/dataset_quality/data_streams/{dataStream}/degraded_field/{degradedField}/analyze',
  params: t.type({
    path: t.type({
      dataStream: t.string,
      degradedField: t.string
    }),
    query: t.type({
      lastBackingIndex: t.string
    })
  }),
  options: {
    tags: []
  },
  async handler(resources) {
    const {
      context,
      params
    } = resources;
    const coreContext = await context.core;
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    const degradedFieldAnalysis = await (0, _get_degraded_field_analysis.analyzeDegradedField)({
      esClient,
      dataStream: params.path.dataStream,
      degradedField: params.path.degradedField,
      lastBackingIndex: params.query.lastBackingIndex
    });
    return degradedFieldAnalysis;
  }
});
const dataStreamsRouteRepository = exports.dataStreamsRouteRepository = {
  ...statsRoute,
  ...degradedDocsRoute,
  ...nonAggregatableDatasetsRoute,
  ...nonAggregatableDatasetRoute,
  ...degradedFieldsRoute,
  ...degradedFieldValuesRoute,
  ...dataStreamDetailsRoute,
  ...dataStreamSettingsRoute,
  ...analyzeDegradedFieldRoute
};