"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNonAggregatableDataStreams = getNonAggregatableDataStreams;
var _queries = require("@kbn/observability-plugin/server/utils/queries");
var _utils = require("../../../common/utils");
var _es_fields = require("../../../common/es_fields");
var _utils2 = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getNonAggregatableDataStreams({
  esClient,
  types,
  start,
  end,
  dataStream
}) {
  var _response$fields$_ign, _ignoredField$non_agg, _ignoredField$aggrega;
  const datasetQualityESClient = (0, _utils2.createDatasetQualityESClient)(esClient);
  const dataStreamTypes = types.map(type => `${type}-*-*`).join(',');
  const response = await datasetQualityESClient.fieldCaps({
    index: dataStream !== null && dataStream !== void 0 ? dataStream : dataStreamTypes,
    fields: [_es_fields._IGNORED],
    index_filter: {
      ...(0, _queries.rangeQuery)(start, end)[0]
    }
  });
  const ignoredField = (_response$fields$_ign = response.fields._ignored) === null || _response$fields$_ign === void 0 ? void 0 : _response$fields$_ign._ignored;
  const nonAggregatableIndices = (_ignoredField$non_agg = ignoredField === null || ignoredField === void 0 ? void 0 : ignoredField.non_aggregatable_indices) !== null && _ignoredField$non_agg !== void 0 ? _ignoredField$non_agg : [];
  const nonAggregatableDatasets = new Set((Array.isArray(nonAggregatableIndices) ? nonAggregatableIndices : [nonAggregatableIndices]).map(_utils.extractIndexNameFromBackingIndex));
  return {
    aggregatable: (_ignoredField$aggrega = ignoredField === null || ignoredField === void 0 ? void 0 : ignoredField.aggregatable) !== null && _ignoredField$aggrega !== void 0 ? _ignoredField$aggrega : true,
    datasets: Array.from(nonAggregatableDatasets)
  };
}