"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.analyzeDegradedField = analyzeDegradedField;
var _utils = require("../../../utils");
var _get_datastream_mappings = require("./get_datastream_mappings");
var _get_datastream_settings = require("./get_datastream_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: The API should also in future return some analysis around the ignore_malformed check.
// As this check is expensive and steps are not very concrete, its not done for the initial iteration
async function analyzeDegradedField({
  esClient,
  dataStream,
  degradedField,
  lastBackingIndex
}) {
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const [{
    fieldCount,
    fieldPresent,
    fieldMapping
  }, {
    nestedFieldLimit,
    totalFieldLimit,
    ignoreDynamicBeyondLimit,
    ignoreMalformed
  }] = await Promise.all([(0, _get_datastream_mappings.getDataStreamMapping)({
    datasetQualityESClient,
    dataStream,
    field: degradedField,
    lastBackingIndex
  }), (0, _get_datastream_settings.getDataStreamSettings)({
    datasetQualityESClient,
    dataStream,
    lastBackingIndex
  })]);
  return {
    isFieldLimitIssue: Boolean(!fieldPresent && ignoreDynamicBeyondLimit && fieldCount === totalFieldLimit),
    fieldCount,
    fieldMapping,
    totalFieldLimit,
    ignoreMalformed,
    nestedFieldLimit
  };
}