"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamSettings = getDataStreamSettings;
var _to_boolean = require("../../../utils/to_boolean");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD_LIMIT = 1000;
const DEFAULT_NESTED_FIELD_LIMIT = 50;
async function getDataStreamSettings({
  datasetQualityESClient,
  dataStream,
  lastBackingIndex
}) {
  var _settings$lastBacking, _settings$lastBacking2, _settings$lastBacking3, _indexSettings$nested, _indexSettings$nested2, _indexSettings$total_, _indexSettings$total_2, _indexSettings$total_3;
  const settings = await datasetQualityESClient.settings({
    index: dataStream
  });
  const indexSettings = (_settings$lastBacking = settings[lastBackingIndex]) === null || _settings$lastBacking === void 0 ? void 0 : (_settings$lastBacking2 = _settings$lastBacking.settings) === null || _settings$lastBacking2 === void 0 ? void 0 : (_settings$lastBacking3 = _settings$lastBacking2.index) === null || _settings$lastBacking3 === void 0 ? void 0 : _settings$lastBacking3.mapping;
  return {
    nestedFieldLimit: indexSettings !== null && indexSettings !== void 0 && (_indexSettings$nested = indexSettings.nested_fields) !== null && _indexSettings$nested !== void 0 && _indexSettings$nested.limit ? Number(indexSettings === null || indexSettings === void 0 ? void 0 : (_indexSettings$nested2 = indexSettings.nested_fields) === null || _indexSettings$nested2 === void 0 ? void 0 : _indexSettings$nested2.limit) : DEFAULT_NESTED_FIELD_LIMIT,
    totalFieldLimit: indexSettings !== null && indexSettings !== void 0 && (_indexSettings$total_ = indexSettings.total_fields) !== null && _indexSettings$total_ !== void 0 && _indexSettings$total_.limit ? Number(indexSettings === null || indexSettings === void 0 ? void 0 : (_indexSettings$total_2 = indexSettings.total_fields) === null || _indexSettings$total_2 === void 0 ? void 0 : _indexSettings$total_2.limit) : DEFAULT_FIELD_LIMIT,
    ignoreDynamicBeyondLimit: (0, _to_boolean.toBoolean)(indexSettings === null || indexSettings === void 0 ? void 0 : (_indexSettings$total_3 = indexSettings.total_fields) === null || _indexSettings$total_3 === void 0 ? void 0 : _indexSettings$total_3.ignore_dynamic_beyond_limit),
    ignoreMalformed: (0, _to_boolean.toBoolean)(indexSettings === null || indexSettings === void 0 ? void 0 : indexSettings.ignore_malformed)
  };
}