"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIntegrationDashboardsFailedNotifier = exports.fetchDataStreamSettingsFailedNotifier = exports.fetchDataStreamIntegrationFailedNotifier = exports.fetchDataStreamDetailsFailedNotifier = exports.assertBreakdownFieldEcsFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDataStreamDetailsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchDataStreamDetailsFailed', {
      defaultMessage: "We couldn't get your datastream details."
    }),
    text: error.message
  });
};
exports.fetchDataStreamDetailsFailedNotifier = fetchDataStreamDetailsFailedNotifier;
const assertBreakdownFieldEcsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.checkBreakdownFieldEcsFailed', {
      defaultMessage: "We couldn't retrieve breakdown field metadata."
    }),
    text: error.message
  });
};
exports.assertBreakdownFieldEcsFailedNotifier = assertBreakdownFieldEcsFailedNotifier;
const fetchDataStreamSettingsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchDataStreamSettingsFailed', {
      defaultMessage: "Data stream settings couldn't be loaded."
    }),
    text: error.message
  });
};
exports.fetchDataStreamSettingsFailedNotifier = fetchDataStreamSettingsFailedNotifier;
const fetchIntegrationDashboardsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchIntegrationDashboardsFailed', {
      defaultMessage: "We couldn't get your integration dashboards."
    }),
    text: error.message
  });
};
exports.fetchIntegrationDashboardsFailedNotifier = fetchIntegrationDashboardsFailedNotifier;
const fetchDataStreamIntegrationFailedNotifier = (toasts, error, integrationName) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.details.fetchIntegrationsFailed', {
      defaultMessage: "We couldn't get {integrationName} integration info.",
      values: {
        integrationName
      }
    }),
    text: error.message
  });
};
exports.fetchDataStreamIntegrationFailedNotifier = fetchDataStreamIntegrationFailedNotifier;