"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CONTEXT = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CONTEXT = exports.DEFAULT_CONTEXT = {
  degradedFields: {
    table: {
      page: 0,
      rowsPerPage: 10,
      sort: {
        field: _constants.DEFAULT_DEGRADED_FIELD_SORT_FIELD,
        direction: _constants.DEFAULT_DEGRADED_FIELD_SORT_DIRECTION
      }
    }
  },
  isIndexNotFoundError: false,
  timeRange: {
    ..._constants.DEFAULT_TIME_RANGE,
    refresh: _constants.DEFAULT_DATEPICKER_REFRESH
  },
  showCurrentQualityIssues: false
};