"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIntegrationsFailedNotifier = exports.fetchDegradedStatsFailedNotifier = exports.fetchDatasetStatsFailedNotifier = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchDatasetStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDatasetStatsFailed', {
      defaultMessage: "We couldn't get your data sets."
    }),
    text: error.message
  });
};
exports.fetchDatasetStatsFailedNotifier = fetchDatasetStatsFailedNotifier;
const fetchDegradedStatsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchDegradedStatsFailed', {
      defaultMessage: "We couldn't get your degraded docs information."
    }),
    text: error.message
  });
};
exports.fetchDegradedStatsFailedNotifier = fetchDegradedStatsFailedNotifier;
const fetchIntegrationsFailedNotifier = (toasts, error) => {
  toasts.addDanger({
    title: _i18n.i18n.translate('xpack.datasetQuality.fetchIntegrationsFailed', {
      defaultMessage: "We couldn't get your integrations."
    }),
    text: error.message
  });
};
exports.fetchIntegrationsFailedNotifier = fetchIntegrationsFailedNotifier;