"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsStatsClient = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _constants = require("../../../common/constants");
var _api_types = require("../../../common/api_types");
var _integration = require("../../../common/data_streams_stats/integration");
var _errors = require("../../../common/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamsStatsClient {
  constructor(http) {
    this.http = http;
  }
  async getDataStreamsStats(params) {
    const types = params.types.length === 0 ? _constants.KNOWN_TYPES : params.types;
    const response = await this.http.get('/internal/dataset_quality/data_streams/stats', {
      query: {
        ...params,
        types: _rison.default.encodeArray(types)
      }
    }).catch(error => {
      throw new _errors.DatasetQualityError(`Failed to fetch data streams stats: ${error}`, error);
    });
    const {
      dataStreamsStats,
      datasetUserPrivileges
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsStatsResponseRt, message => new _errors.DatasetQualityError(`Failed to decode data streams stats response: ${message}`))(response);
    return {
      dataStreamsStats,
      datasetUserPrivileges
    };
  }
  async getDataStreamsDegradedStats(params) {
    const response = await this.http.get('/internal/dataset_quality/data_streams/degraded_docs', {
      query: {
        ...params
      }
    }).catch(error => {
      throw new _errors.DatasetQualityError(`Failed to fetch data streams degraded stats: ${error}`, error);
    });
    const {
      degradedDocs
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getDataStreamsDegradedDocsStatsResponseRt, message => new _errors.DatasetQualityError(`Failed to decode data streams degraded docs stats response: ${message}`))(response);
    return degradedDocs;
  }
  async getNonAggregatableDatasets(params) {
    const types = params.types.length === 0 ? _constants.KNOWN_TYPES : params.types;
    const response = await this.http.get('/internal/dataset_quality/data_streams/non_aggregatable', {
      query: {
        ...params,
        types: _rison.default.encodeArray(types)
      }
    }).catch(error => {
      throw new _errors.DatasetQualityError(`Failed to fetch non aggregatable datasets: ${error}`, error);
    });
    const nonAggregatableDatasets = (0, _ioTsUtils.decodeOrThrow)(_api_types.getNonAggregatableDatasetsRt, message => new _errors.DatasetQualityError(`Failed to fetch non aggregatable datasets: ${message}`))(response);
    return nonAggregatableDatasets;
  }
  async getIntegrations() {
    const response = await this.http.get('/internal/dataset_quality/integrations').catch(error => {
      throw new _errors.DatasetQualityError(`Failed to fetch integrations: ${error}`, error);
    });
    const {
      integrations
    } = (0, _ioTsUtils.decodeOrThrow)(_api_types.getIntegrationsResponseRt, message => new _errors.DatasetQualityError(`Failed to decode integrations response: ${message}`))(response);
    return integrations.map(_integration.Integration.create);
  }
}
exports.DataStreamsStatsClient = DataStreamsStatsClient;