"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSummaryPanelContext = exports.default = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("@xstate/react");
var _data_stream_stat = require("../../common/data_streams_stats/data_stream_stat");
var _ = require(".");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSummaryPanel = () => {
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    filteredItems,
    canUserMonitorDataset,
    canUserMonitorAnyDataStream,
    loading
  } = (0, _.useDatasetQualityTable)();
  const {
    timeRange
  } = (0, _react.useSelector)(service, state => state.context.filters);

  /*
    Datasets Quality
  */

  const datasetsQuality = {
    percentages: filteredItems.map(item => item.degradedDocs.percentage)
  };
  const isDatasetsQualityLoading = (0, _react.useSelector)(service, state => state.matches('stats.degradedDocs.fetching'));

  /*
    User Authorization
  */
  const canUserMonitorAllFilteredDataStreams = filteredItems.every(item => {
    var _item$userPrivileges$, _item$userPrivileges;
    return (_item$userPrivileges$ = (_item$userPrivileges = item.userPrivileges) === null || _item$userPrivileges === void 0 ? void 0 : _item$userPrivileges.canMonitor) !== null && _item$userPrivileges$ !== void 0 ? _item$userPrivileges$ : true;
  });
  const isUserAuthorizedForDataset = !loading ? canUserMonitorDataset && canUserMonitorAnyDataStream && canUserMonitorAllFilteredDataStreams : true;

  /*
    Datasets Activity
  */
  const datasetsActivity = {
    total: filteredItems.length,
    active: (0, _utils.filterInactiveDatasets)({
      datasets: filteredItems,
      timeRange
    }).length
  };
  const isDatasetsActivityLoading = (0, _react.useSelector)(service, state => state.matches('stats.datasets.fetching'));

  /*
    Estimated Data
  */
  const estimatedData = filteredItems.reduce((acc, curr) => acc + _data_stream_stat.DataStreamStat.calculateFilteredSize(curr), 0);
  const isEstimatedDataLoading = (0, _react.useSelector)(service, state => state.matches('stats.datasets.fetching') || state.matches('stats.degradedDocs.fetching'));
  return {
    datasetsQuality,
    isDatasetsQualityLoading,
    isUserAuthorizedForDataset,
    isEstimatedDataLoading,
    estimatedData,
    isDatasetsActivityLoading,
    datasetsActivity,
    numberOfDatasets: filteredItems.length,
    numberOfDocuments: filteredItems.reduce((acc, curr) => acc + curr.degradedDocs.docsCount, 0)
  };
};
const [SummaryPanelProvider, useSummaryPanelContext] = (0, _constate.default)(useSummaryPanel);
exports.useSummaryPanelContext = useSummaryPanelContext;
// eslint-disable-next-line import/no-default-export
var _default = exports.default = SummaryPanelProvider;