"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewSummaryPanel = void 0;
var _react = require("@xstate/react");
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _context = require("../components/dataset_quality_details/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOverviewSummaryPanel = () => {
  var _useSelector, _dataStreamDetails$se, _dataStreamDetails$us, _dataStreamDetails$us2, _dataStreamDetails$ho, _dataStreamDetails$de;
  const {
    service
  } = (0, _context.useDatasetQualityDetailsContext)();
  const context = (_useSelector = (0, _react.useSelector)(service, state => state.context)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const isSummaryPanelLoading = (0, _react.useSelector)(service, state => state.matches('initializing.dataStreamDetails.fetching'));
  const dataStreamDetails = 'dataStreamDetails' in context ? context.dataStreamDetails : {};
  const services = (_dataStreamDetails$se = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.services) !== null && _dataStreamDetails$se !== void 0 ? _dataStreamDetails$se : {};
  const serviceKeys = Object.keys(services);
  const totalServicesCount = serviceKeys.map(key => services[key].length).reduce((a, b) => a + b, 0);
  const totalDocsCount = (0, _eui.formatNumber)(dataStreamDetails.docsCount, _constants.NUMBER_FORMAT);
  const sizeInBytes = (0, _eui.formatNumber)(dataStreamDetails.sizeBytes, _constants.BYTE_NUMBER_FORMAT);
  const isUserAllowedToSeeSizeInBytes = (_dataStreamDetails$us = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : (_dataStreamDetails$us2 = dataStreamDetails.userPrivileges) === null || _dataStreamDetails$us2 === void 0 ? void 0 : _dataStreamDetails$us2.canMonitor) !== null && _dataStreamDetails$us !== void 0 ? _dataStreamDetails$us : true;
  const hosts = (_dataStreamDetails$ho = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.hosts) !== null && _dataStreamDetails$ho !== void 0 ? _dataStreamDetails$ho : {};
  const hostKeys = Object.keys(hosts);
  const countOfHosts = hostKeys.map(key => hosts[key].length).reduce(({
    count,
    anyHostExceedsMax
  }, hostCount) => ({
    count: count + hostCount,
    anyHostExceedsMax: anyHostExceedsMax || hostCount > _constants.MAX_HOSTS_METRIC_VALUE
  }), {
    count: 0,
    anyHostExceedsMax: false
  });
  const totalHostsCount = formatMetricValueForMax(countOfHosts.anyHostExceedsMax ? countOfHosts.count + 1 : countOfHosts.count, countOfHosts.count, _constants.NUMBER_FORMAT);
  const totalDegradedDocsCount = (0, _eui.formatNumber)((_dataStreamDetails$de = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.degradedDocsCount) !== null && _dataStreamDetails$de !== void 0 ? _dataStreamDetails$de : 0, _constants.NUMBER_FORMAT);
  return {
    totalDocsCount,
    sizeInBytes,
    isUserAllowedToSeeSizeInBytes,
    totalServicesCount,
    totalHostsCount,
    isSummaryPanelLoading,
    totalDegradedDocsCount
  };
};

/**
 * Formats a metric value to show a '+' sign if it's above a max value e.g. 50+
 */
exports.useOverviewSummaryPanel = useOverviewSummaryPanel;
function formatMetricValueForMax(value, max, numberFormat) {
  const exceedsMax = value > max;
  const valueToShow = exceedsMax ? max : value;
  return `${(0, _eui.formatNumber)(valueToShow, numberFormat)}${exceedsMax ? '+' : ''}`;
}