"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDegradedFields = useDegradedFields;
var _react = require("@xstate/react");
var _react2 = require("react");
var _lodash = require("lodash");
var _constants = require("../../common/constants");
var _utils = require("../utils");
var _use_dataset_quality_details_state = require("./use_dataset_quality_details_state");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDegradedFields() {
  var _data$length;
  const {
    service
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    degradedFields,
    expandedDegradedField,
    showCurrentQualityIssues
  } = (0, _react.useSelector)(service, state => state.context);
  const {
    data,
    table
  } = degradedFields !== null && degradedFields !== void 0 ? degradedFields : {};
  const {
    page,
    rowsPerPage,
    sort
  } = table;
  const totalItemCount = (_data$length = data === null || data === void 0 ? void 0 : data.length) !== null && _data$length !== void 0 ? _data$length : 0;
  const pagination = {
    pageIndex: page,
    pageSize: rowsPerPage,
    totalItemCount,
    hidePerPageOptions: true
  };
  const onTableChange = (0, _react2.useCallback)(options => {
    var _options$sort, _options$sort2;
    service.send({
      type: 'UPDATE_DEGRADED_FIELDS_TABLE_CRITERIA',
      degraded_field_criteria: {
        page: options.page.index,
        rowsPerPage: options.page.size,
        sort: {
          field: ((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || _constants.DEFAULT_DEGRADED_FIELD_SORT_FIELD,
          direction: ((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || _constants.DEFAULT_DEGRADED_FIELD_SORT_DIRECTION
        }
      }
    });
  }, [service]);
  const renderedItems = (0, _react2.useMemo)(() => {
    const sortedItems = (0, _lodash.orderBy)(data, sort.field, sort.direction);
    return sortedItems.slice(page * rowsPerPage, (page + 1) * rowsPerPage);
  }, [data, sort.field, sort.direction, page, rowsPerPage]);
  const expandedRenderedItem = (0, _react2.useMemo)(() => {
    return renderedItems.find(item => item.name === expandedDegradedField);
  }, [expandedDegradedField, renderedItems]);
  const isDegradedFieldsLoading = (0, _react.useSelector)(service, state => state.matches('initializing.dataStreamSettings.loadingIntegrationsAndDegradedFields.dataStreamDegradedFields.fetching'));
  const closeDegradedFieldFlyout = (0, _react2.useCallback)(() => service.send({
    type: 'CLOSE_DEGRADED_FIELD_FLYOUT'
  }), [service]);
  const openDegradedFieldFlyout = (0, _react2.useCallback)(fieldName => {
    if (expandedDegradedField === fieldName) {
      service.send({
        type: 'CLOSE_DEGRADED_FIELD_FLYOUT'
      });
    } else {
      service.send({
        type: 'OPEN_DEGRADED_FIELD_FLYOUT',
        fieldName
      });
    }
  }, [expandedDegradedField, service]);
  const toggleCurrentQualityIssues = (0, _react2.useCallback)(() => {
    service.send('TOGGLE_CURRENT_QUALITY_ISSUES');
  }, [service]);
  const degradedFieldValues = (0, _react.useSelector)(service, state => state.matches('initializing.degradedFieldFlyout.open.ignoredValues.done') ? state.context.degradedFieldValues : undefined);
  const degradedFieldAnalysis = (0, _react.useSelector)(service, state => state.matches('initializing.degradedFieldFlyout.open.analyze.done') ? state.context.degradedFieldAnalysis : undefined);

  // This piece only cater field limit issue at the moment.
  // In future this will cater the other 2 reasons as well
  const degradedFieldAnalysisResult = (0, _react2.useMemo)(() => {
    if (!degradedFieldAnalysis) {
      return undefined;
    }

    // 1st check if it's a field limit issue
    if (degradedFieldAnalysis.isFieldLimitIssue) {
      return {
        potentialCause: _translations.degradedFieldCauseFieldLimitExceeded,
        tooltipContent: _translations.degradedFieldCauseFieldLimitExceededTooltip,
        shouldDisplayMitigation: true,
        shouldDisplayValues: false
      };
    }

    // 2nd check if it's a ignored above issue
    const fieldMapping = degradedFieldAnalysis.fieldMapping;
    if (fieldMapping && (fieldMapping === null || fieldMapping === void 0 ? void 0 : fieldMapping.type) === 'keyword' && fieldMapping !== null && fieldMapping !== void 0 && fieldMapping.ignore_above) {
      const isAnyValueExceedingIgnoreAbove = degradedFieldValues === null || degradedFieldValues === void 0 ? void 0 : degradedFieldValues.values.some(value => value.length > fieldMapping.ignore_above);
      if (isAnyValueExceedingIgnoreAbove) {
        return {
          potentialCause: _translations.degradedFieldCauseFieldIgnored,
          tooltipContent: _translations.degradedFieldCauseFieldIgnoredTooltip,
          shouldDisplayMitigation: false,
          shouldDisplayValues: true
        };
      }
    }

    // 3rd check if its a ignore_malformed issue. There is no check, at the moment.
    return {
      potentialCause: _translations.degradedFieldCauseFieldMalformed,
      tooltipContent: _translations.degradedFieldCauseFieldMalformedTooltip,
      shouldDisplayMitigation: false,
      shouldDisplayValues: false
    };
  }, [degradedFieldAnalysis, degradedFieldValues]);
  const isDegradedFieldsValueLoading = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.degradedFieldFlyout.open.ignoredValues.fetching');
  });
  const isAnalysisInProgress = (0, _react.useSelector)(service, state => {
    return state.matches('initializing.degradedFieldFlyout.open.analyze.fetching');
  });
  return {
    isDegradedFieldsLoading,
    pagination,
    onTableChange,
    renderedItems,
    sort: {
      sort
    },
    fieldFormats,
    totalItemCount,
    expandedDegradedField,
    openDegradedFieldFlyout,
    closeDegradedFieldFlyout,
    degradedFieldValues,
    isDegradedFieldsValueLoading,
    isAnalysisInProgress,
    degradedFieldAnalysis,
    degradedFieldAnalysisResult,
    toggleCurrentQualityIssues,
    showCurrentQualityIssues,
    expandedRenderedItem
  };
}