"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDegradedDocsChart = void 0;
var _react = require("react");
var _public = require("@kbn/unified-histogram-plugin/public");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _use_create_dataview = require("./use_create_dataview");
var _utils = require("../utils");
var _use_dataset_quality_details_state = require("./use_dataset_quality_details_state");
var _lens_attributes = require("../components/dataset_quality_details/overview/document_trends/degraded_docs/lens_attributes");
var _use_redirect_link = require("./use_redirect_link");
var _use_dataset_details_telemetry = require("./use_dataset_details_telemetry");
var _use_redirect_link_telemetry = require("./use_redirect_link_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exploreDataInLogsExplorerText = _i18n.i18n.translate('xpack.datasetQuality.details.chartExploreDataInLogsExplorerText', {
  defaultMessage: 'Explore data in Logs Explorer'
});
const exploreDataInDiscoverText = _i18n.i18n.translate('xpack.datasetQuality.details.chartExploreDataInDiscoverText', {
  defaultMessage: 'Explore data in Discover'
});
const openInLensText = _i18n.i18n.translate('xpack.datasetQuality.details.chartOpenInLensText', {
  defaultMessage: 'Open in Lens'
});
const ACTION_EXPLORE_IN_LOGS_EXPLORER = 'ACTION_EXPLORE_IN_LOGS_EXPLORER';
const ACTION_OPEN_IN_LENS = 'ACTION_OPEN_IN_LENS';
const useDegradedDocsChart = () => {
  var _integrationDetails$i4;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      lens
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    service,
    dataStream,
    datasetDetails,
    timeRange,
    breakdownField,
    integrationDetails,
    isBreakdownFieldAsserted
  } = (0, _use_dataset_quality_details_state.useDatasetQualityDetailsState)();
  const {
    trackDatasetDetailsBreakdownFieldChanged,
    trackDetailsNavigated,
    navigationTargets,
    navigationSources
  } = (0, _use_dataset_details_telemetry.useDatasetDetailsTelemetry)();
  const [isChartLoading, setIsChartLoading] = (0, _react.useState)(undefined);
  const [attributes, setAttributes] = (0, _react.useState)(undefined);
  const {
    dataView
  } = (0, _use_create_dataview.useCreateDataView)({
    indexPatternString: getDataViewIndexPattern(dataStream)
  });
  const breakdownDataViewField = (0, _react.useMemo)(() => getDataViewField(dataView, breakdownField), [breakdownField, dataView]);
  const handleChartLoading = isLoading => {
    setIsChartLoading(isLoading);
  };
  const handleBreakdownFieldChange = (0, _react.useCallback)(field => {
    service.send({
      type: 'BREAKDOWN_FIELD_CHANGE',
      breakdownField: field === null || field === void 0 ? void 0 : field.name
    });
  }, [service]);
  (0, _react.useEffect)(() => {
    if (isBreakdownFieldAsserted) trackDatasetDetailsBreakdownFieldChanged();
  }, [trackDatasetDetailsBreakdownFieldChanged, isBreakdownFieldAsserted]);
  (0, _react.useEffect)(() => {
    var _integrationDetails$i, _integrationDetails$i2, _integrationDetails$i3;
    const dataStreamName = dataStream !== null && dataStream !== void 0 ? dataStream : _constants.DEFAULT_LOGS_DATA_VIEW;
    const datasetTitle = (_integrationDetails$i = integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i2 = integrationDetails.integration) === null || _integrationDetails$i2 === void 0 ? void 0 : (_integrationDetails$i3 = _integrationDetails$i2.datasets) === null || _integrationDetails$i3 === void 0 ? void 0 : _integrationDetails$i3[datasetDetails.name]) !== null && _integrationDetails$i !== void 0 ? _integrationDetails$i : datasetDetails.name;
    const lensAttributes = (0, _lens_attributes.getLensAttributes)({
      color: euiTheme.colors.danger,
      dataStream: dataStreamName,
      datasetTitle,
      breakdownFieldName: breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name
    });
    setAttributes(lensAttributes);
  }, [breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name, euiTheme.colors.danger, setAttributes, dataStream, integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i4 = integrationDetails.integration) === null || _integrationDetails$i4 === void 0 ? void 0 : _integrationDetails$i4.datasets, datasetDetails.name]);
  const openInLensCallback = (0, _react.useCallback)(() => {
    if (attributes) {
      trackDetailsNavigated(navigationTargets.Lens, navigationSources.Chart);
      lens.navigateToPrefilledEditor({
        id: '',
        timeRange,
        attributes
      });
    }
  }, [attributes, lens, navigationSources.Chart, navigationTargets.Lens, timeRange, trackDetailsNavigated]);
  const getOpenInLensAction = (0, _react.useMemo)(() => {
    return {
      id: ACTION_OPEN_IN_LENS,
      type: 'link',
      order: 17,
      getDisplayName() {
        return openInLensText;
      },
      getIconType() {
        return 'visArea';
      },
      async isCompatible() {
        return true;
      },
      async execute() {
        return openInLensCallback();
      }
    };
  }, [openInLensCallback]);
  const {
    sendTelemetry
  } = (0, _use_redirect_link_telemetry.useDatasetDetailsRedirectLinkTelemetry)({
    query: {
      language: 'kuery',
      query: '_ignored:*'
    },
    navigationSource: navigationSources.Chart
  });
  const redirectLinkProps = (0, _use_redirect_link.useRedirectLink)({
    dataStreamStat: datasetDetails,
    query: {
      language: 'kuery',
      query: '_ignored:*'
    },
    timeRangeConfig: timeRange,
    breakdownField: breakdownDataViewField === null || breakdownDataViewField === void 0 ? void 0 : breakdownDataViewField.name,
    sendTelemetry
  });
  const getOpenInLogsExplorerAction = (0, _react.useMemo)(() => {
    return {
      id: ACTION_EXPLORE_IN_LOGS_EXPLORER,
      type: 'link',
      getDisplayName() {
        return redirectLinkProps !== null && redirectLinkProps !== void 0 && redirectLinkProps.isLogsExplorerAvailable ? exploreDataInLogsExplorerText : exploreDataInDiscoverText;
      },
      getHref: async () => {
        return redirectLinkProps.linkProps.href;
      },
      getIconType() {
        return 'visTable';
      },
      async isCompatible() {
        return true;
      },
      async execute() {
        return redirectLinkProps.navigate();
      },
      order: 18
    };
  }, [redirectLinkProps]);
  const extraActions = [getOpenInLensAction, getOpenInLogsExplorerAction];
  const breakdown = (0, _react.useMemo)(() => {
    return {
      dataViewField: breakdownDataViewField,
      fieldSupportsBreakdown: breakdownDataViewField ? (0, _public.fieldSupportsBreakdown)(breakdownDataViewField) : true,
      onChange: handleBreakdownFieldChange
    };
  }, [breakdownDataViewField, handleBreakdownFieldChange]);
  return {
    attributes,
    dataView,
    breakdown,
    extraActions,
    isChartLoading,
    onChartLoading: handleChartLoading,
    setAttributes,
    setIsChartLoading
  };
};
exports.useDegradedDocsChart = useDegradedDocsChart;
function getDataViewIndexPattern(dataStream) {
  return dataStream !== null && dataStream !== void 0 ? dataStream : _constants.DEFAULT_LOGS_DATA_VIEW;
}
function getDataViewField(dataView, fieldName) {
  return fieldName && dataView ? dataView.fields.find(field => field.name === fieldName) : undefined;
}