"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetTelemetry = useDatasetTelemetry;
var _react = require("@xstate/react");
var _react2 = require("react");
var _timerange = require("@kbn/timerange");
var _context = require("../components/dataset_quality/context");
var _use_dataset_quality_filters = require("./use_dataset_quality_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDatasetTelemetry() {
  var _useSelector;
  const {
    service,
    telemetryClient
  } = (0, _context.useDatasetQualityContext)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const datasets = (_useSelector = (0, _react.useSelector)(service, state => state.context.datasets)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const nonAggregatableDatasets = (0, _react.useSelector)(service, state => state.context.nonAggregatableDatasets);
  const canUserViewIntegrations = (0, _react.useSelector)(service, state => state.context.datasetUserPrivileges.canViewIntegrations);
  const sort = (0, _react.useSelector)(service, state => state.context.table.sort);
  const appliedFilters = (0, _use_dataset_quality_filters.useDatasetQualityFilters)();
  const trackDatasetNavigated = (0, _react2.useCallback)((rawName, isIgnoredFilter) => {
    const foundDataset = datasets.find(dataset => dataset.rawName === rawName);
    if (foundDataset) {
      const ebtProps = getDatasetEbtProps(foundDataset, sort, appliedFilters, nonAggregatableDatasets, isIgnoredFilter, canUserViewIntegrations);
      telemetryClient.trackDatasetNavigated(ebtProps);
    } else {
      throw new Error(`Cannot report dataset navigation telemetry for unknown dataset ${rawName}`);
    }
  }, [sort, appliedFilters, canUserViewIntegrations, datasets, nonAggregatableDatasets, telemetryClient]);
  return {
    trackDatasetNavigated
  };
}
function getDatasetEbtProps(dataset, sort, filters, nonAggregatableDatasets, isIgnoredFilter, canUserViewIntegrations) {
  var _dataset$integration, _dataset$userPrivileg, _dataset$userPrivileg2, _filters$selectedQuer, _filters$selectedQuer2;
  const {
    startDate: from,
    endDate: to
  } = (0, _timerange.getDateISORange)(filters.timeRange);
  const datasetEbtProps = {
    index_name: dataset.rawName,
    data_stream: {
      dataset: dataset.name,
      namespace: dataset.namespace,
      type: dataset.type
    },
    data_stream_health: dataset.degradedDocs.quality,
    data_stream_aggregatable: nonAggregatableDatasets.some(indexName => indexName === dataset.rawName),
    from,
    to,
    degraded_percentage: dataset.degradedDocs.percentage,
    integration: (_dataset$integration = dataset.integration) === null || _dataset$integration === void 0 ? void 0 : _dataset$integration.name,
    privileges: {
      can_monitor_data_stream: (_dataset$userPrivileg = (_dataset$userPrivileg2 = dataset.userPrivileges) === null || _dataset$userPrivileg2 === void 0 ? void 0 : _dataset$userPrivileg2.canMonitor) !== null && _dataset$userPrivileg !== void 0 ? _dataset$userPrivileg : true,
      can_view_integrations: canUserViewIntegrations
    }
  };
  const ebtFilters = {
    is_degraded: isIgnoredFilter,
    query_length: (_filters$selectedQuer = (_filters$selectedQuer2 = filters.selectedQuery) === null || _filters$selectedQuer2 === void 0 ? void 0 : _filters$selectedQuer2.length) !== null && _filters$selectedQuer !== void 0 ? _filters$selectedQuer : 0,
    integrations: {
      total: filters.integrations.filter(item => item.name !== 'none').length,
      included: filters.integrations.filter(item => (item === null || item === void 0 ? void 0 : item.checked) === 'on').length,
      excluded: filters.integrations.filter(item => (item === null || item === void 0 ? void 0 : item.checked) === 'off').length
    },
    namespaces: {
      total: filters.namespaces.length,
      included: filters.namespaces.filter(item => (item === null || item === void 0 ? void 0 : item.checked) === 'on').length,
      excluded: filters.namespaces.filter(item => (item === null || item === void 0 ? void 0 : item.checked) === 'off').length
    },
    qualities: {
      total: filters.qualities.length,
      included: filters.qualities.filter(item => (item === null || item === void 0 ? void 0 : item.checked) === 'on').length,
      excluded: filters.qualities.filter(item => (item === null || item === void 0 ? void 0 : item.checked) === 'off').length
    }
  };
  return {
    ...datasetEbtProps,
    sort,
    filters: ebtFilters
  };
}