"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityTable = void 0;
var _react = require("@xstate/react");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _constants = require("../../common/constants");
var _data_stream_stat = require("../../common/data_streams_stats/data_stream_stat");
var _translations = require("../../common/translations");
var _columns = require("../components/dataset_quality/table/columns");
var _context = require("../components/dataset_quality/context");
var _utils = require("../utils");
var _filter_inactive_datasets = require("../utils/filter_inactive_datasets");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortingOverrides = {
  ['title']: 'name',
  ['size']: _data_stream_stat.DataStreamStat.calculateFilteredSize
};
const useDatasetQualityTable = () => {
  const {
    services: {
      fieldFormats,
      share: {
        url
      }
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const {
    service
  } = (0, _context.useDatasetQualityContext)();
  const {
    page,
    rowsPerPage,
    sort
  } = (0, _react.useSelector)(service, state => state.context.table);
  const canUserMonitorDataset = (0, _react.useSelector)(service, state => state.context.datasetUserPrivileges.canMonitor);
  const canUserMonitorAnyDataStream = (0, _react.useSelector)(service, state => !state.context.dataStreamStats || state.context.datasets.some(s => {
    var _s$userPrivileges;
    return (_s$userPrivileges = s.userPrivileges) === null || _s$userPrivileges === void 0 ? void 0 : _s$userPrivileges.canMonitor;
  }));
  const {
    inactive,
    fullNames: showFullDatasetNames,
    timeRange,
    integrations,
    namespaces,
    qualities,
    query
  } = (0, _react.useSelector)(service, state => state.context.filters);
  const showInactiveDatasets = inactive || !canUserMonitorDataset;
  const loading = (0, _react.useSelector)(service, state => state.matches('stats.datasets.fetching') || state.matches('integrations.fetching') || state.matches('stats.degradedDocs.fetching'));
  const loadingDataStreamStats = (0, _react.useSelector)(service, state => state.matches('stats.datasets.fetching'));
  const loadingDegradedStats = (0, _react.useSelector)(service, state => state.matches('stats.degradedDocs.fetching'));
  const datasets = (0, _react.useSelector)(service, state => state.context.datasets);
  const toggleInactiveDatasets = (0, _react2.useCallback)(() => service.send({
    type: 'TOGGLE_INACTIVE_DATASETS'
  }), [service]);
  const toggleFullDatasetNames = (0, _react2.useCallback)(() => service.send({
    type: 'TOGGLE_FULL_DATASET_NAMES'
  }), [service]);
  const isActive = (0, _react2.useCallback)(lastActivity => (0, _filter_inactive_datasets.isActiveDataset)({
    lastActivity,
    timeRange
  }), [timeRange]);
  const columns = (0, _react2.useMemo)(() => (0, _columns.getDatasetQualityTableColumns)({
    fieldFormats,
    canUserMonitorDataset,
    canUserMonitorAnyDataStream,
    loadingDataStreamStats,
    loadingDegradedStats,
    showFullDatasetNames,
    isActiveDataset: isActive,
    timeRange,
    urlService: url
  }), [fieldFormats, canUserMonitorDataset, canUserMonitorAnyDataStream, loadingDataStreamStats, loadingDegradedStats, showFullDatasetNames, isActive, timeRange, url]);
  const filteredItems = (0, _react2.useMemo)(() => {
    const visibleDatasets = showInactiveDatasets ? datasets : (0, _filter_inactive_datasets.filterInactiveDatasets)({
      datasets,
      timeRange
    });
    return visibleDatasets.filter(dataset => {
      const passesIntegrationFilter = integrations.length === 0 || !dataset.integration && integrations.includes(_constants.NONE) || dataset.integration && integrations.includes(dataset.integration.name);
      const passesNamespaceFilter = namespaces.length === 0 || namespaces.includes(dataset.namespace);
      const passesQualityFilter = qualities.length === 0 || qualities.includes(dataset.degradedDocs.quality);
      const passesQueryFilter = !query || dataset.rawName.includes(query);
      return passesIntegrationFilter && passesNamespaceFilter && passesQualityFilter && passesQueryFilter;
    });
  }, [showInactiveDatasets, datasets, timeRange, integrations, namespaces, qualities, query]);
  const pagination = {
    pageIndex: page,
    pageSize: rowsPerPage,
    totalItemCount: filteredItems.length,
    hidePerPageOptions: true
  };
  const onTableChange = (0, _react2.useCallback)(options => {
    var _options$sort, _options$sort2;
    service.send({
      type: 'UPDATE_TABLE_CRITERIA',
      dataset_criteria: {
        page: options.page.index,
        rowsPerPage: options.page.size,
        sort: {
          field: ((_options$sort = options.sort) === null || _options$sort === void 0 ? void 0 : _options$sort.field) || _constants.DEFAULT_SORT_FIELD,
          direction: ((_options$sort2 = options.sort) === null || _options$sort2 === void 0 ? void 0 : _options$sort2.direction) || _constants.DEFAULT_SORT_DIRECTION
        }
      }
    });
  }, [service]);
  const renderedItems = (0, _react2.useMemo)(() => {
    const overridenSortingField = sortingOverrides[sort.field] || sort.field;
    const sortedItems = (0, _lodash.orderBy)(filteredItems, overridenSortingField, sort.direction);
    return sortedItems.slice(page * rowsPerPage, (page + 1) * rowsPerPage);
  }, [sort.field, sort.direction, filteredItems, page, rowsPerPage]);
  const resultsCount = (0, _react2.useMemo)(() => {
    const startNumberItemsOnPage = rowsPerPage * page + (renderedItems.length ? 1 : 0);
    const endNumberItemsOnPage = rowsPerPage * page + renderedItems.length;
    return rowsPerPage === 0 ? /*#__PURE__*/_react2.default.createElement("strong", null, _translations.tableSummaryAllText) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("strong", null, startNumberItemsOnPage, "-", endNumberItemsOnPage), ' ', _translations.tableSummaryOfText, " ", datasets.length);
  }, [rowsPerPage, page, renderedItems.length, datasets.length]);
  return {
    sort: {
      sort
    },
    onTableChange,
    pagination,
    filteredItems,
    renderedItems,
    columns,
    loading,
    resultsCount,
    showInactiveDatasets,
    showFullDatasetNames,
    canUserMonitorDataset,
    canUserMonitorAnyDataStream,
    toggleInactiveDatasets,
    toggleFullDatasetNames
  };
};
exports.useDatasetQualityTable = useDatasetQualityTable;