"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPublicStateFromContext = exports.getContextFromPublicState = void 0;
var _dataset_quality_details_controller = require("../../state_machines/dataset_quality_details_controller");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPublicStateFromContext = context => {
  return {
    dataStream: context.dataStream,
    degradedFields: context.degradedFields,
    timeRange: context.timeRange,
    breakdownField: context.breakdownField,
    integration: context.integration,
    expandedDegradedField: context.expandedDegradedField,
    showCurrentQualityIssues: context.showCurrentQualityIssues
  };
};
exports.getPublicStateFromContext = getPublicStateFromContext;
const getContextFromPublicState = publicState => {
  var _publicState$degraded, _publicState$degraded2, _publicState$degraded3, _publicState$timeRang, _publicState$showCurr;
  return {
    ..._dataset_quality_details_controller.DEFAULT_CONTEXT,
    degradedFields: {
      table: {
        ..._dataset_quality_details_controller.DEFAULT_CONTEXT.degradedFields.table,
        ...((_publicState$degraded = publicState.degradedFields) === null || _publicState$degraded === void 0 ? void 0 : _publicState$degraded.table),
        sort: (_publicState$degraded2 = publicState.degradedFields) !== null && _publicState$degraded2 !== void 0 && (_publicState$degraded3 = _publicState$degraded2.table) !== null && _publicState$degraded3 !== void 0 && _publicState$degraded3.sort ? {
          ...publicState.degradedFields.table.sort,
          field: publicState.degradedFields.table.sort.field
        } : _dataset_quality_details_controller.DEFAULT_CONTEXT.degradedFields.table.sort
      }
    },
    timeRange: {
      ..._dataset_quality_details_controller.DEFAULT_CONTEXT.timeRange,
      ...publicState.timeRange,
      refresh: {
        ..._dataset_quality_details_controller.DEFAULT_CONTEXT.timeRange.refresh,
        ...((_publicState$timeRang = publicState.timeRange) === null || _publicState$timeRang === void 0 ? void 0 : _publicState$timeRang.refresh)
      }
    },
    dataStream: publicState.dataStream,
    expandedDegradedField: publicState.expandedDegradedField,
    showCurrentQualityIssues: (_publicState$showCurr = publicState.showCurrentQualityIssues) !== null && _publicState$showCurr !== void 0 ? _publicState$showCurr : _dataset_quality_details_controller.DEFAULT_CONTEXT.showCurrentQualityIssues
  };
};
exports.getContextFromPublicState = getContextFromPublicState;