"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIndicator = QualityIndicator;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QualityIndicator({
  quality,
  description,
  isColoredDescription
}) {
  const qualityColors = {
    poor: 'danger',
    degraded: 'warning',
    good: 'success'
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: qualityColors[quality]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: isColoredDescription ? qualityColors[quality] : 'white'
  }, description));
}