"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Summary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _panel = require("./panel");
var _translations = require("../../../../../common/translations");
var _use_overview_summary_panel = require("../../../../hooks/use_overview_summary_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Summary() {
  const {
    isSummaryPanelLoading,
    totalDocsCount,
    sizeInBytes,
    isUserAllowedToSeeSizeInBytes,
    totalServicesCount,
    totalHostsCount,
    totalDegradedDocsCount
  } = (0, _use_overview_summary_panel.useOverviewSummaryPanel)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleDocuments
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDocumentsIndicatorTotalCount,
    value: totalDocsCount,
    isLoading: isSummaryPanelLoading
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDocumentsIndicatorSize,
    value: sizeInBytes,
    isLoading: isSummaryPanelLoading,
    userHasPrivilege: isUserAllowedToSeeSizeInBytes
  })), /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleResources
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelResourcesIndicatorServices,
    value: totalServicesCount,
    isLoading: isSummaryPanelLoading
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelResourcesIndicatorSize,
    value: totalHostsCount,
    isLoading: isSummaryPanelLoading
  })), /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleDatasetQuality
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDatasetQualityIndicatorDegradedDocs,
    value: totalDegradedDocsCount,
    isLoading: isSummaryPanelLoading
  })));
}
module.exports = exports.default;