"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Overview = Overview;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
var _aggregation_not_supported = require("./aggregation_not_supported");
var _degraded_fields = require("./degraded_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverviewHeader = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./header'))));
const Summary = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./summary'))));
const DegradedDocs = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./document_trends/degraded_docs'))));
function Overview() {
  const {
    dataStream,
    isNonAggregatable,
    updateTimeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const [lastReloadTime, setLastReloadTime] = (0, _react.useState)(Date.now());
  const handleRefresh = (0, _react.useCallback)(refreshProps => {
    updateTimeRange(refreshProps);
    setLastReloadTime(Date.now());
  }, [updateTimeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isNonAggregatable && /*#__PURE__*/_react.default.createElement(_aggregation_not_supported.AggregationNotSupported, {
    dataStream: dataStream
  }), /*#__PURE__*/_react.default.createElement(OverviewHeader, {
    handleRefresh: handleRefresh
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(Summary, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(DegradedDocs, {
    lastReloadTime: lastReloadTime
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_degraded_fields.DegradedFields, null));
}