"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedFieldTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _columns = require("./columns");
var _translations = require("../../../../../common/translations");
var _use_degraded_fields = require("../../../../hooks/use_degraded_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DegradedFieldTable = () => {
  const {
    isDegradedFieldsLoading,
    pagination,
    renderedItems,
    onTableChange,
    sort,
    fieldFormats,
    expandedDegradedField,
    openDegradedFieldFlyout
  } = (0, _use_degraded_fields.useDegradedFields)();
  const dateFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  const columns = (0, _columns.getDegradedFieldsColumns)({
    dateFormatter,
    isLoading: isDegradedFieldsLoading,
    expandedDegradedField,
    openDegradedFieldFlyout
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "fixed",
    columns: columns,
    items: renderedItems !== null && renderedItems !== void 0 ? renderedItems : [],
    loading: isDegradedFieldsLoading,
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    "data-test-subj": "datasetQualityDetailsDegradedFieldTable",
    rowProps: {
      'data-test-subj': 'datasetQualityDetailsDegradedTableRow'
    },
    noItemsMessage: isDegradedFieldsLoading ? _translations.overviewDegradedFieldsTableLoadingText : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "datasetQualityDetailsDegradedTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.overviewDegradedFieldsTableNoData),
      hasBorder: false,
      titleSize: "m"
    })
  });
};
exports.DegradedFieldTable = DegradedFieldTable;