"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDegradedFieldsColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _spark_plot = require("../../../common/spark_plot");
var _constants = require("../../../../../common/constants");
var _translations = require("../../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expandDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.details.degradedFieldTable.expandLabel', {
  defaultMessage: 'Expand'
});
const collapseDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.details.degradedFieldTable.collapseLabel', {
  defaultMessage: 'Collapse'
});
const getDegradedFieldsColumns = ({
  dateFormatter,
  isLoading,
  expandedDegradedField,
  openDegradedFieldFlyout
}) => [{
  name: '',
  field: 'name',
  render: (_, {
    name
  }) => {
    const isExpanded = name === expandedDegradedField;
    const onExpandClick = () => {
      openDegradedFieldFlyout(name);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "datasetQualityDetailsDegradedFieldsExpandButton",
      size: "xs",
      color: "text",
      onClick: onExpandClick,
      iconType: isExpanded ? 'minimize' : 'expand',
      title: !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel,
      "aria-label": !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel
    });
  },
  width: '40px',
  css: (0, _react2.css)`
      &.euiTableCellContent {
        padding: 0;
      }
    `
}, {
  name: _translations.fieldColumnName,
  field: 'name'
}, {
  name: _translations.countColumnName,
  sortable: true,
  field: 'count',
  render: (_, {
    count,
    timeSeries
  }) => {
    const countValue = (0, _eui.formatNumber)(count, _constants.NUMBER_FORMAT);
    return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
      series: timeSeries,
      valueLabel: countValue,
      isLoading: isLoading
    });
  }
}, {
  name: _translations.lastOccurrenceColumnName,
  sortable: true,
  field: 'lastOccurrence',
  render: lastOccurrence => {
    return dateFormatter.convert(lastOccurrence);
  }
}];
exports.getDegradedFieldsColumns = getDegradedFieldsColumns;