"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _translations = require("../../../common/translations");
var _hooks = require("../../hooks");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Header() {
  var _integrationDetails$i, _integrationDetails$i2, _integrationDetails$i3;
  const {
    datasetDetails,
    timeRange,
    integrationDetails,
    loadingState
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    navigationSources
  } = (0, _hooks.useDatasetDetailsTelemetry)();
  const {
    rawName,
    name: title
  } = datasetDetails;
  const euiShadow = (0, _eui.useEuiShadow)('s');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    navigationSource: navigationSources.Header
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: datasetDetails,
    timeRangeConfig: timeRange,
    sendTelemetry
  });
  const pageTitle = (_integrationDetails$i = integrationDetails === null || integrationDetails === void 0 ? void 0 : (_integrationDetails$i2 = integrationDetails.integration) === null || _integrationDetails$i2 === void 0 ? void 0 : (_integrationDetails$i3 = _integrationDetails$i2.datasets) === null || _integrationDetails$i3 === void 0 ? void 0 : _integrationDetails$i3[datasetDetails.name]) !== null && _integrationDetails$i !== void 0 ? _integrationDetails$i : title;
  return !loadingState.integrationDetailsLoaded ? /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonTitle, {
    size: "s",
    "data-test-subj": "datasetQualityDetailsIntegrationLoading",
    className: "datasetQualityDetailsIntegrationLoading"
  }) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "datasetQualityDetailsTitle",
    size: "l"
  }, /*#__PURE__*/_react2.default.createElement("h2", null, pageTitle)), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                ${euiShadow};
                padding: ${euiTheme.size.xs};
                border-radius: ${euiTheme.size.xxs};
              `
  }, /*#__PURE__*/_react2.default.createElement(_common.IntegrationIcon, {
    integration: integrationDetails === null || integrationDetails === void 0 ? void 0 : integrationDetails.integration
  }))), /*#__PURE__*/_react2.default.createElement("p", null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, rawName)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
            margin-right: ${euiTheme.size.l};
          `,
    gutterSize: "s",
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": "datasetQualityDetailsHeaderButton",
    size: "s"
  }, redirectLinkProps.linkProps, {
    iconType: redirectLinkProps.isLogsExplorerAvailable ? 'logoObservability' : 'discoverApp'
  }), redirectLinkProps.isLogsExplorerAvailable ? _translations.openInLogsExplorerText : _translations.openInDiscoverText))));
}