"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetSummary = DatasetSummary;
var _react = _interopRequireWildcard(require("react"));
var _fieldTypes = require("@kbn/field-types");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _integration_actions_menu = require("./integration_actions_menu");
var _translations = require("../../../../common/translations");
var _fields_list = require("./fields_list");
var _hooks = require("../../../hooks");
var _common = require("../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DatasetSummary() {
  var _integrationDetails$i, _integrationDetails$i2;
  const {
    fieldFormats,
    dataStreamSettings,
    dataStreamDetails,
    loadingState,
    integrationDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const dataFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  const {
    dataStreamDetailsLoading,
    dataStreamSettingsLoading,
    integrationDetailsLoadings,
    integrationDashboardsLoading
  } = loadingState;
  const formattedLastActivity = dataStreamDetails !== null && dataStreamDetails !== void 0 && dataStreamDetails.lastActivity ? dataFormatter.convert(dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.lastActivity) : '-';
  const formattedCreatedOn = dataStreamSettings !== null && dataStreamSettings !== void 0 && dataStreamSettings.createdOn ? dataFormatter.convert(dataStreamSettings.createdOn) : '-';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_fields_list.FieldsList, {
    fields: [...(integrationDetails !== null && integrationDetails !== void 0 && integrationDetails.integration ? [{
      fieldTitle: _translations.integrationNameText,
      fieldValue: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        css: (0, _react2.css)`
                          width: fit-content;
                        `
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_common.IntegrationIcon, {
        integration: integrationDetails.integration
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, (_integrationDetails$i = integrationDetails.integration) === null || _integrationDetails$i === void 0 ? void 0 : _integrationDetails$i.name))),
      actionsMenu: /*#__PURE__*/_react.default.createElement(_integration_actions_menu.IntegrationActionsMenu, {
        integration: integrationDetails.integration,
        dashboards: integrationDetails.dashboard,
        dashboardsLoading: integrationDashboardsLoading
      }),
      isLoading: integrationDetailsLoadings
    }, {
      fieldTitle: _translations.integrationVersionText,
      fieldValue: (_integrationDetails$i2 = integrationDetails.integration) === null || _integrationDetails$i2 === void 0 ? void 0 : _integrationDetails$i2.version,
      isLoading: integrationDetailsLoadings
    }] : []), {
      fieldTitle: _translations.datasetLastActivityText,
      fieldValue: formattedLastActivity,
      isLoading: dataStreamDetailsLoading
    }, {
      fieldTitle: _translations.datasetCreatedOnText,
      fieldValue: formattedCreatedOn,
      isLoading: dataStreamSettingsLoading
    }]
  })));
}