"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DegradedFieldFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _telemetry = require("../../../services/telemetry");
var _hooks = require("../../../hooks");
var _translations = require("../../../../common/translations");
var _field_info = require("./field_info");
var _es_fields = require("../../../../common/es_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function DegradedFieldFlyout() {
  const {
    closeDegradedFieldFlyout,
    expandedDegradedField,
    renderedItems
  } = (0, _hooks.useDegradedFields)();
  const {
    dataStreamSettings,
    datasetDetails,
    timeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const pushedFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'pushedFlyoutTitle'
  });
  const fieldList = (0, _react.useMemo)(() => {
    return renderedItems.find(item => {
      return item.name === expandedDegradedField;
    });
  }, [renderedItems, expandedDegradedField]);
  const isUserViewingTheIssueOnLatestBackingIndex = (dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.lastBackingIndexName) === (fieldList === null || fieldList === void 0 ? void 0 : fieldList.indexFieldWasLastPresentIn);
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetDetailsRedirectLinkTelemetry)({
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: ${expandedDegradedField}`
    },
    navigationSource: _telemetry.NavigationSource.DegradedFieldFlyoutHeader
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat: datasetDetails,
    timeRangeConfig: timeRange,
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: ${expandedDegradedField}`
    },
    sendTelemetry
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    type: "push",
    size: "s",
    onClose: closeDegradedFieldFlyout,
    "aria-labelledby": pushedFlyoutTitleId,
    "data-test-subj": 'datasetQualityDetailsDegradedFieldFlyout'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _translations.overviewDegradedFieldsSectionTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, expandedDegradedField, " ", /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontWeight: 400
    }
  }, _translations.fieldIgnoredText))), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: redirectLinkProps.isLogsExplorerAvailable ? _translations.openInLogsExplorerText : _translations.openInDiscoverText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    display: "base",
    iconType: redirectLinkProps.isLogsExplorerAvailable ? 'logoObservability' : 'discoverApp',
    "aria-label": redirectLinkProps.isLogsExplorerAvailable ? _translations.logsExplorerAriaText : _translations.discoverAriaText,
    size: "s",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutTitleLinkToDiscover"
  }, redirectLinkProps.linkProps)))), !isUserViewingTheIssueOnLatestBackingIndex && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutIssueDoesNotExist"
  }, _translations.degradedFieldMessageIssueDoesNotExistInLatestIndex))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_field_info.DegradedFieldInfo, {
    fieldList: fieldList
  })));
}
module.exports = exports.default;