"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DegradedDocsPercentageLink = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _es_fields = require("../../../../common/es_fields");
var _hooks = require("../../../hooks");
var _quality_indicator = require("../../quality_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DegradedDocsPercentageLink = ({
  isLoading,
  dataStreamStat,
  timeRange
}) => {
  const {
    degradedDocs: {
      percentage,
      count
    }
  } = dataStreamStat;
  const {
    sendTelemetry
  } = (0, _hooks.useDatasetRedirectLinkTelemetry)({
    rawName: dataStreamStat.rawName,
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: *`
    }
  });
  const redirectLinkProps = (0, _hooks.useRedirectLink)({
    dataStreamStat,
    query: {
      language: 'kuery',
      query: `${_es_fields._IGNORED}: *`
    },
    sendTelemetry,
    timeRangeConfig: timeRange
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "50px",
    height: "20px",
    borderRadius: "m",
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, percentage ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "datasetQualityDegradedDocsPercentageLink"
  }, redirectLinkProps.linkProps), /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
    percentage: percentage,
    degradedDocsCount: count
  })) : /*#__PURE__*/_react.default.createElement(_quality_indicator.QualityPercentageIndicator, {
    percentage: percentage
  })));
};
exports.DegradedDocsPercentageLink = DegradedDocsPercentageLink;