"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNKOWN_FIELD_PLACEHOLDER = exports.POOR_QUALITY_MINIMUM_PERCENTAGE = exports.NUMBER_FORMAT = exports.NONE = exports.MAX_HOSTS_METRIC_VALUE = exports.MAX_DEGRADED_FIELDS = exports.MASKED_FIELD_PLACEHOLDER = exports.KNOWN_TYPES = exports.DEGRADED_QUALITY_MINIMUM_PERCENTAGE = exports.DEFAULT_TIME_RANGE = exports.DEFAULT_SORT_FIELD = exports.DEFAULT_SORT_DIRECTION = exports.DEFAULT_LOGS_DATA_VIEW = exports.DEFAULT_DEGRADED_FIELD_SORT_FIELD = exports.DEFAULT_DEGRADED_FIELD_SORT_DIRECTION = exports.DEFAULT_DEGRADED_DOCS = exports.DEFAULT_DATEPICKER_REFRESH = exports.DEFAULT_DATASET_TYPE = exports.DATASET_QUALITY_APP_ID = exports.BYTE_NUMBER_FORMAT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATASET_QUALITY_APP_ID = exports.DATASET_QUALITY_APP_ID = 'dataset_quality';
const DEFAULT_DATASET_TYPE = exports.DEFAULT_DATASET_TYPE = 'logs';
const DEFAULT_LOGS_DATA_VIEW = exports.DEFAULT_LOGS_DATA_VIEW = 'logs-*-*';
const POOR_QUALITY_MINIMUM_PERCENTAGE = exports.POOR_QUALITY_MINIMUM_PERCENTAGE = 3;
const DEGRADED_QUALITY_MINIMUM_PERCENTAGE = exports.DEGRADED_QUALITY_MINIMUM_PERCENTAGE = 0;
const DEFAULT_SORT_FIELD = exports.DEFAULT_SORT_FIELD = 'title';
const DEFAULT_SORT_DIRECTION = exports.DEFAULT_SORT_DIRECTION = 'asc';
const DEFAULT_DEGRADED_FIELD_SORT_FIELD = exports.DEFAULT_DEGRADED_FIELD_SORT_FIELD = 'count';
const DEFAULT_DEGRADED_FIELD_SORT_DIRECTION = exports.DEFAULT_DEGRADED_FIELD_SORT_DIRECTION = 'desc';
const NONE = exports.NONE = 'none';
const DEFAULT_TIME_RANGE = exports.DEFAULT_TIME_RANGE = {
  from: 'now-24h',
  to: 'now'
};
const DEFAULT_DATEPICKER_REFRESH = exports.DEFAULT_DATEPICKER_REFRESH = {
  value: 60000,
  pause: false
};
const DEFAULT_DEGRADED_DOCS = exports.DEFAULT_DEGRADED_DOCS = {
  percentage: 0,
  count: 0,
  docsCount: 0,
  quality: 'good'
};
const NUMBER_FORMAT = exports.NUMBER_FORMAT = '0,0.[000]';
const BYTE_NUMBER_FORMAT = exports.BYTE_NUMBER_FORMAT = '0.0 b';
const MAX_HOSTS_METRIC_VALUE = exports.MAX_HOSTS_METRIC_VALUE = 50;
const MAX_DEGRADED_FIELDS = exports.MAX_DEGRADED_FIELDS = 1000;
const MASKED_FIELD_PLACEHOLDER = exports.MASKED_FIELD_PLACEHOLDER = '<custom field>';
const UNKOWN_FIELD_PLACEHOLDER = exports.UNKOWN_FIELD_PLACEHOLDER = '<unkwon>';
const KNOWN_TYPES = exports.KNOWN_TYPES = ['logs', 'metrics', 'traces', 'synthetics'];