"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildAggregationWithSamplingOption = buildAggregationWithSamplingOption;
var _field_stats = require("../../../../../common/types/field_stats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildAggregationWithSamplingOption(aggs, samplingOption) {
  if (!samplingOption) {
    return aggs;
  }
  const {
    seed
  } = samplingOption;
  if ((0, _field_stats.isNormalSamplingOption)(samplingOption)) {
    return {
      sample: {
        sampler: {
          shard_size: samplingOption.shardSize
        },
        aggs
      }
    };
  }
  if ((0, _field_stats.isRandomSamplingOption)(samplingOption)) {
    return {
      sample: {
        // @ts-expect-error AggregationsAggregationContainer needs to be updated with random_sampler
        random_sampler: {
          probability: samplingOption.probability,
          ...(seed ? {
            seed
          } : {})
        },
        aggs
      }
    };
  }

  // Else, if no sampling, use random sampler with probability set to 1
  // this is so that all results are returned under 'sample' path
  return {
    sample: {
      aggs,
      // @ts-expect-error AggregationsAggregationContainer needs to be updated with random_sampler
      random_sampler: {
        probability: 1,
        ...(seed ? {
          seed
        } : {})
      }
    }
  };
}