"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocatorParams = exports.IndexDataVisualizer = void 0;
require("../_index.scss");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _rison = require("@kbn/rison");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlNestedProperty = require("@kbn/ml-nested-property");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _mlUrlState = require("@kbn/ml-url-state");
var _esqlUtils = require("@kbn/esql-utils");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../kibana_services");
var _index_data_visualizer_view = require("./components/index_data_visualizer_view");
var _index_data_visualizer_esql = require("./components/index_data_visualizer_view/index_data_visualizer_esql");
var _kibana_context = require("../kibana_context");
var _locator = require("./locator");
var _index_data_visualizer_viewer = require("./constants/index_data_visualizer_viewer");
var _constants = require("../common/constants");
var _storage = require("./types/storage");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const XXL_BREAKPOINT = 1400;
const localStorage = new _public.Storage(window.localStorage);
const getLocatorParams = params => {
  const urlState = (0, _mlUrlState.parseUrlState)(params.urlSearchString);
  let locatorParams = {
    dataViewId: urlState.index,
    searchSessionId: params.searchSessionId
  };
  if (params.savedSearchId) locatorParams.savedSearchId = params.savedSearchId;
  if (urlState) {
    if (urlState._g) {
      const {
        time,
        refreshInterval
      } = urlState._g;
      locatorParams.timeRange = time;
      locatorParams.refreshInterval = refreshInterval;
    }
    if (urlState._a && urlState._a[_index_data_visualizer_viewer.DATA_VISUALIZER_INDEX_VIEWER]) {
      locatorParams = {
        ...locatorParams,
        ...urlState._a[_index_data_visualizer_viewer.DATA_VISUALIZER_INDEX_VIEWER]
      };
    }
  }
  return locatorParams;
};
exports.getLocatorParams = getLocatorParams;
const DataVisualizerESQLStateContextProvider = () => {
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const isEsqlEnabled = (0, _react.useMemo)(() => services.uiSettings.get(_esqlUtils.ENABLE_ESQL), [services.uiSettings]);
  if (!isEsqlEnabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.esqlNotEnabledCalloutTitle",
        defaultMessage: "ES|QL is not enabled"
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, null, /*#__PURE__*/_react.default.createElement(_index_data_visualizer_esql.IndexDataVisualizerESQL, null));
};
const DataVisualizerStateContextProvider = ({
  IndexDataVisualizerComponent,
  getAdditionalLinks
}) => {
  const {
    services
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    data: {
      dataViews,
      search
    },
    savedObjects: {
      client: savedObjectsClient
    },
    notifications: {
      toasts
    },
    savedSearch: savedSearchService
  } = services;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    search: urlSearchString
  } = (0, _reactRouterDom.useLocation)();
  const [currentDataView, setCurrentDataView] = (0, _react.useState)(undefined);
  const [currentSavedSearch, setCurrentSavedSearch] = (0, _react.useState)(null);
  const [currentSessionId, setCurrentSessionId] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const urlState = (0, _mlUrlState.parseUrlState)(urlSearchString);
    if (search.session) {
      search.session.enableStorage({
        getName: async () => {
          // return the name you want to give the saved Search Session
          return _constants.INDEX_DATA_VISUALIZER_NAME;
        },
        getLocatorData: async () => {
          return {
            id: _locator.DATA_VISUALIZER_APP_LOCATOR,
            initialState: getLocatorParams({
              ...services,
              urlSearchString,
              dataViewId: currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.id,
              savedSearchId: currentSavedSearch === null || currentSavedSearch === void 0 ? void 0 : currentSavedSearch.id,
              shouldRestoreSearchSession: false,
              searchSessionId: search.session.getSessionId()
            }),
            restoreState: getLocatorParams({
              ...services,
              urlSearchString,
              dataViewId: currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.id,
              savedSearchId: currentSavedSearch === null || currentSavedSearch === void 0 ? void 0 : currentSavedSearch.id,
              shouldRestoreSearchSession: true,
              searchSessionId: search.session.getSessionId()
            })
          };
        }
      });
    }
    if (urlState.searchSessionId !== undefined && urlState.searchSessionId !== currentSessionId) {
      var _search$session;
      (_search$session = search.session) === null || _search$session === void 0 ? void 0 : _search$session.restore(urlState.searchSessionId);
      setCurrentSessionId(urlState.searchSessionId);
    } else {
      var _search$session2;
      const newSessionId = (_search$session2 = search.session) === null || _search$session2 === void 0 ? void 0 : _search$session2.start();
      setCurrentSessionId(newSessionId);
    }
    return () => {
      search.session.clear();
    };
    // urlSearchString already includes all the other dependencies
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [search.session, urlSearchString]);
  (0, _react.useEffect)(() => {
    const prevSearchString = urlSearchString;
    const parsedQueryString = (0, _queryString.parse)(prevSearchString, {
      sort: false
    });
    const getDataView = async () => {
      if (typeof (parsedQueryString === null || parsedQueryString === void 0 ? void 0 : parsedQueryString.savedSearchId) === 'string') {
        const savedSearchId = parsedQueryString.savedSearchId;
        try {
          const savedSearch = await savedSearchService.get(savedSearchId);
          const dataView = savedSearch.searchSource.getField('index');
          if (!dataView) {
            toasts.addDanger({
              title: _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewErrorMessage', {
                defaultMessage: 'Error finding data view'
              })
            });
          }
          setCurrentSavedSearch(savedSearch);
          setCurrentDataView(dataView);
        } catch (e) {
          toasts.addError(e, {
            title: _i18n.i18n.translate('xpack.dataVisualizer.index.savedSearchErrorMessage', {
              defaultMessage: 'Error retrieving saved search {savedSearchId}',
              values: {
                savedSearchId
              }
            })
          });
        }
      }
      if (typeof (parsedQueryString === null || parsedQueryString === void 0 ? void 0 : parsedQueryString.index) === 'string') {
        const dataView = await dataViews.get(parsedQueryString.index);
        setCurrentDataView(dataView);
      }
    };
    getDataView();
  }, [savedObjectsClient, toasts, dataViews, urlSearchString, search, savedSearchService]);
  const setUrlState = (0, _react.useCallback)((accessor, attribute, value, replaceState) => {
    const prevSearchString = urlSearchString;
    const urlState = (0, _mlUrlState.parseUrlState)(prevSearchString);
    const parsedQueryString = (0, _queryString.parse)(prevSearchString, {
      sort: false
    });
    if (!Object.hasOwn(urlState, accessor)) {
      urlState[accessor] = {};
    }
    if (typeof attribute === 'string') {
      if ((0, _lodash.isEqual)((0, _mlNestedProperty.getNestedProperty)(urlState, `${accessor}.${attribute}`), value)) {
        return prevSearchString;
      }
      urlState[accessor][attribute] = value;
    } else {
      const attributes = attribute;
      Object.keys(attributes).forEach(a => {
        urlState[accessor][a] = attributes[a];
      });
    }
    try {
      const oldLocationSearchString = (0, _queryString.stringify)(parsedQueryString, {
        sort: false,
        encode: false
      });
      Object.keys(urlState).forEach(a => {
        if ((0, _mlUrlState.isRisonSerializationRequired)(a)) {
          parsedQueryString[a] = (0, _rison.encode)(urlState[a]);
        } else {
          parsedQueryString[a] = urlState[a];
        }
      });
      const newLocationSearchString = (0, _queryString.stringify)(parsedQueryString, {
        sort: false,
        encode: false
      });
      if (oldLocationSearchString !== newLocationSearchString) {
        const newSearchString = (0, _queryString.stringify)(parsedQueryString, {
          sort: false
        });
        if (replaceState) {
          history.replace({
            search: newSearchString
          });
        } else {
          history.push({
            search: newSearchString
          });
        }
      }
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error('Could not save url state', error);
    }
  }, [history, urlSearchString]);
  return /*#__PURE__*/_react.default.createElement(_mlUrlState.Provider, {
    value: {
      searchString: urlSearchString,
      setUrlState
    }
  }, currentDataView ? /*#__PURE__*/_react.default.createElement(IndexDataVisualizerComponent, {
    currentDataView: currentDataView,
    currentSavedSearch: currentSavedSearch,
    currentSessionId: currentSessionId,
    getAdditionalLinks: getAdditionalLinks
  }) : null);
};
const IndexDataVisualizer = ({
  getAdditionalLinks,
  showFrozenDataTierChoice = true,
  esql
}) => {
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    ...coreStart,
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  };
  const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme');
  const datePickerDeps = {
    ...(0, _lodash.pick)(services, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, startServices, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: coreStart.theme,
    modify: {
      breakpoint: {
        xxl: XXL_BREAKPOINT
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...services
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.DV_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, !esql ? /*#__PURE__*/_react.default.createElement(DataVisualizerStateContextProvider, {
    IndexDataVisualizerComponent: _index_data_visualizer_view.IndexDataVisualizerView,
    getAdditionalLinks: getAdditionalLinks
  }) : /*#__PURE__*/_react.default.createElement(DataVisualizerESQLStateContextProvider, null))))));
};
exports.IndexDataVisualizer = IndexDataVisualizer;