"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeFieldStatsControls = void 0;
var _rxjs = require("rxjs");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _esqlUtils = require("@kbn/esql-utils");
var _types = require("../grid_embeddable/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeFieldStatsControls = (rawState, uiSettings) => {
  var _rawState$viewType;
  const isEsqlEnabled = uiSettings.get(_esqlUtils.ENABLE_ESQL);
  const defaultType = isEsqlEnabled ? _types.FieldStatsInitializerViewType.ESQL : _types.FieldStatsInitializerViewType.DATA_VIEW;
  const viewType$ = new _rxjs.BehaviorSubject((_rawState$viewType = rawState.viewType) !== null && _rawState$viewType !== void 0 ? _rawState$viewType : defaultType);
  const dataViewId$ = new _rxjs.BehaviorSubject(rawState.dataViewId);
  const query$ = new _rxjs.BehaviorSubject(rawState.query);
  const showDistributions$ = new _rxjs.BehaviorSubject(rawState.showDistributions);
  const resetData$ = new _rxjs.BehaviorSubject(Date.now());
  const dataLoading$ = new _rxjs.BehaviorSubject(true);
  const blockingError = new _rxjs.BehaviorSubject(undefined);
  const updateUserInput = (update, shouldResetData = false) => {
    if (shouldResetData) {
      resetData$.next(Date.now());
    }
    viewType$.next(update.viewType);
    dataViewId$.next(update.dataViewId);
    query$.next(update.query);
  };
  const serializeFieldStatsChartState = () => {
    return {
      viewType: viewType$.getValue(),
      dataViewId: dataViewId$.getValue(),
      query: query$.getValue(),
      showDistributions: showDistributions$.getValue()
    };
  };
  const fieldStatsControlsComparators = {
    viewType: [viewType$, arg => viewType$.next(arg)],
    dataViewId: [dataViewId$, arg => dataViewId$.next(arg)],
    query: [query$, arg => query$.next(arg), _fastDeepEqual.default],
    showDistributions: [showDistributions$, arg => showDistributions$.next(arg)]
  };
  const onRenderComplete = () => dataLoading$.next(false);
  const onLoading = v => dataLoading$.next(v);
  const onError = error => blockingError.next(error);
  return {
    fieldStatsControlsApi: {
      viewType$,
      dataViewId$,
      query$,
      updateUserInput,
      showDistributions$
    },
    dataLoadingApi: {
      dataLoading: dataLoading$,
      onRenderComplete,
      onLoading,
      onError,
      blockingError
    },
    // Reset data is internal state management, so no need to expose this in api
    resetData$,
    serializeFieldStatsChartState,
    fieldStatsControlsComparators,
    onFieldStatsTableDestroy: () => {
      viewType$.complete();
      dataViewId$.complete();
      query$.complete();
      resetData$.complete();
    }
  };
};
exports.initializeFieldStatsControls = initializeFieldStatsControls;