"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatisticsInitializer = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _esqlUtils = require("@kbn/esql-utils");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _kibana_context = require("../../../kibana_context");
var _field_stats_esql_editor = require("./field_stats_esql_editor");
var _types = require("../grid_embeddable/types");
var _esql_utils = require("../../search_strategy/requests/esql_utils");
var _field_stats_initializer_view_type = require("./field_stats_initializer_view_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultESQLQuery = {
  esql: ''
};
const defaultTitle = _i18n.i18n.translate('xpack.dataVisualizer.fieldStatistics.displayName', {
  defaultMessage: 'Field statistics'
});
const isScrollable = false;
const FieldStatisticsInitializer = ({
  initialInput,
  onCreate,
  onCancel,
  onPreview,
  isNewPanel
}) => {
  var _initialInput$dataVie, _initialInput$viewTyp, _initialInput$query;
  const {
    data: {
      dataViews
    },
    unifiedSearch: {
      ui: {
        IndexPatternSelect
      }
    },
    uiSettings
  } = (0, _kibana_context.useDataVisualizerKibana)().services;
  const [dataViewId, setDataViewId] = (0, _react.useState)((_initialInput$dataVie = initialInput === null || initialInput === void 0 ? void 0 : initialInput.dataViewId) !== null && _initialInput$dataVie !== void 0 ? _initialInput$dataVie : '');
  const [viewType, setViewType] = (0, _react.useState)((_initialInput$viewTyp = initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewType) !== null && _initialInput$viewTyp !== void 0 ? _initialInput$viewTyp : _types.FieldStatsInitializerViewType.DATA_VIEW);
  const [esqlQuery, setQuery] = (0, _react.useState)((_initialInput$query = initialInput === null || initialInput === void 0 ? void 0 : initialInput.query) !== null && _initialInput$query !== void 0 ? _initialInput$query : defaultESQLQuery);
  const isEsqlEnabled = (0, _react.useMemo)(() => uiSettings.get(_esqlUtils.ENABLE_ESQL), [uiSettings]);
  (0, _react.useEffect)(() => {
    if ((initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewType) === undefined) {
      // By default, if ES|QL is enabled, then use ES|QL
      setViewType(isEsqlEnabled ? _types.FieldStatsInitializerViewType.ESQL : _types.FieldStatsInitializerViewType.DATA_VIEW);
    }
  }, [isEsqlEnabled, initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewType]);
  const isEsqlMode = viewType === _types.FieldStatsInitializerViewType.ESQL;
  const updatedProps = (0, _react.useMemo)(() => {
    var _initialInput$title;
    return {
      viewType,
      title: (_initialInput$title = initialInput === null || initialInput === void 0 ? void 0 : initialInput.title) !== null && _initialInput$title !== void 0 ? _initialInput$title : defaultTitle,
      dataViewId,
      query: isEsqlMode ? esqlQuery : undefined
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dataViewId, viewType, esqlQuery.esql, isEsqlMode]);
  const onESQLQuerySubmit = (0, _react.useCallback)(async (query, abortController) => {
    const adhocDataView = await (0, _esqlUtils.getESQLAdHocDataview)(query.esql, dataViews);
    if (adhocDataView && adhocDataView.id) {
      setDataViewId(adhocDataView.id);
    }
    await onPreview({
      viewType,
      dataViewId: adhocDataView === null || adhocDataView === void 0 ? void 0 : adhocDataView.id,
      query
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [isEsqlMode]);
  const isEsqlFormValid = isEsqlMode ? isEsqlEnabled && (0, _esql_utils.isESQLQuery)(esqlQuery) : true;
  const isDataViewFormValid = viewType === _types.FieldStatsInitializerViewType.DATA_VIEW ? dataViewId !== '' : true;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    css: (0, _react2.css)`
          pointer-events: auto;
          background-color: ${_uiTheme.euiThemeVars.euiColorEmptyShade};
        `,
    "data-test-subj": "editFlyoutHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "inlineEditingFlyoutLabel"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isNewPanel ? _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.createLable', {
    defaultMessage: 'Create field statistics'
  }) : _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.editLabel', {
    defaultMessage: 'Edit field statistics'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "iInCircle",
    content: _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.samplingTooltip', {
      defaultMessage: 'Field statistics uses the random sampling aggregation to increase performance, but some accuracy might be lost.'
    })
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    className: "lnsEditFlyoutBody",
    css: (0, _react2.css)`
          // styles needed to display extra drop targets that are outside of the config panel main area
          overflow-y: auto;
          padding-left: ${_uiTheme.euiThemeVars.euiFormMaxWidth};
          margin-left: -${_uiTheme.euiThemeVars.euiFormMaxWidth};
          pointer-events: none;
          .euiFlyoutBody__overflow {
            -webkit-mask-image: none;
            padding-left: inherit;
            margin-left: inherit;
            ${!isScrollable && `
                overflow-y: hidden;
              `}
            > * {
              pointer-events: auto;
            }
          }
          .euiFlyoutBody__overflowContent {
            padding: 0;
            block-size: 100%;
          }
          border-bottom: 2px solid ${_uiTheme.euiThemeVars.euiBorderColor};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            block-size: 100%;
          `,
    direction: "column",
    gutterSize: "none"
  }, isNewPanel ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    iconType: "iInCircle",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.description",
      defaultMessage: "The visualization displays summarized information and statistics to show how each field in your data is populated."
    })
  }) : null, (initialInput === null || initialInput === void 0 ? void 0 : initialInput.viewType) === _types.FieldStatsInitializerViewType.ESQL && !isEsqlEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_stats_initializer_view_type.DataSourceTypeSelector, {
    value: viewType,
    onChange: setViewType
  })) : null, viewType === _types.FieldStatsInitializerViewType.ESQL && !isEsqlEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, esqlQuery.esql)) : null, viewType === _types.FieldStatsInitializerViewType.DATA_VIEW ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.dataViewLabel', {
      defaultMessage: 'Data view'
    }),
    css: (0, _react2.css)({
      padding: _uiTheme.euiThemeVars.euiSizeM
    })
  }, /*#__PURE__*/_react.default.createElement(IndexPatternSelect, {
    autoFocus: !dataViewId,
    fullWidth: true,
    compressed: true,
    indexPatternId: dataViewId,
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.dataViewSelectorPlaceholder', {
      defaultMessage: 'Select data view'
    }),
    onChange: newId => {
      setDataViewId(newId !== null && newId !== void 0 ? newId : '');
    }
  })) : null, isEsqlMode && isEsqlEnabled ? /*#__PURE__*/_react.default.createElement(_field_stats_esql_editor.FieldStatsESQLEditor, {
    query: esqlQuery,
    setQuery: setQuery,
    onQuerySubmit: onESQLQuerySubmit
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "fieldStatsInitializerCancelButton",
    flush: "left",
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel applied changes'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCreate.bind(null, updatedProps),
    fill: true,
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.applyFlyoutAriaLabel', {
      defaultMessage: 'Apply changes'
    }),
    disabled: !isEsqlFormValid || !isDataViewFormValid,
    iconType: "check",
    "data-test-subj": "applyFlyoutButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.fieldStatisticsDashboardPanel.config.applyAndCloseLabel",
    defaultMessage: "Apply and close"
  }))))));
};
exports.FieldStatisticsInitializer = FieldStatisticsInitializer;