"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPanelContent = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _common = require("@kbn/data-plugin/common");
var _kibana_context = require("../../../kibana_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchPanelContent = ({
  searchQuery,
  searchString,
  searchQueryLanguage,
  dataView,
  setSearchParams
}) => {
  const {
    services: {
      uiSettings,
      notifications: {
        toasts
      },
      data: {
        query: queryManager
      },
      unifiedSearch: {
        ui: {
          SearchBar
        }
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)({
    query: searchString || '',
    language: searchQueryLanguage
  });
  (0, _react.useEffect)(() => {
    setSearchInput({
      query: searchString || '',
      language: searchQueryLanguage
    });
  }, [searchQueryLanguage, searchString, queryManager.filterManager]);
  const searchHandler = ({
    query,
    filters
  }) => {
    const mergedQuery = (0, _mlIsDefined.isDefined)(query) ? query : searchInput;
    const mergedFilters = (0, _mlIsDefined.isDefined)(filters) ? filters : queryManager.filterManager.getFilters();
    try {
      var _queryManager$filterM;
      if (mergedFilters) {
        queryManager.filterManager.setFilters(mergedFilters);
      }
      const combinedQuery = (0, _esQuery.buildEsQuery)(dataView, mergedQuery ? [mergedQuery] : [], (_queryManager$filterM = queryManager.filterManager.getFilters()) !== null && _queryManager$filterM !== void 0 ? _queryManager$filterM : [], uiSettings ? (0, _common.getEsQueryConfig)(uiSettings) : undefined);
      setSearchParams({
        searchQuery: combinedQuery,
        searchString: mergedQuery.query,
        queryLanguage: mergedQuery.language,
        filters: mergedFilters
      });
    } catch (e) {
      console.log('Invalid syntax', JSON.stringify(e, null, 2)); // eslint-disable-line no-console
      toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.invalidSyntax', {
          defaultMessage: 'Invalid syntax'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(SearchBar, {
    dataTestSubj: "dataVisualizerQueryInput",
    appName: 'dataVisualizer',
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: true,
    query: searchInput,
    onQuerySubmit: params => searchHandler({
      query: params.query
    }),
    onFiltersUpdated: filters => searchHandler({
      filters
    }),
    indexPatterns: [dataView],
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.queryBarPlaceholderText', {
      defaultMessage: 'Search… (e.g. status:200 AND extension:"PHP")'
    }),
    displayStyle: 'inPage',
    isClearable: true,
    customSubmitButton: /*#__PURE__*/_react.default.createElement("div", null)
  });
};
exports.SearchPanelContent = SearchPanelContent;