"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileSizeChecker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _constants = require("../../../../../common/constants");
var _tika_utils = require("../../../../../common/utils/tika_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FileSizeChecker {
  constructor(fileUpload, file) {
    (0, _defineProperty2.default)(this, "_maxBytes", void 0);
    (0, _defineProperty2.default)(this, "_fileSize", void 0);
    this._fileSize = file.size;
    this._maxBytes = (0, _tika_utils.isTikaType)(file.type) ? fileUpload.getMaxTikaBytes() : fileUpload.getMaxBytes();
  }
  check() {
    return this._fileSize <= this._maxBytes;
  }
  maxBytes() {
    return this._maxBytes;
  }
  fileSizeFormatted() {
    return (0, _numeral.default)(this._fileSize).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
  }
  maxFileSizeFormatted() {
    return (0, _numeral.default)(this._maxBytes).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
  }
  fileSizeDiffFormatted() {
    return (0, _numeral.default)(this._fileSize - this._maxBytes).format(_constants.FILE_SIZE_DISPLAY_FORMAT);
  }
}
exports.FileSizeChecker = FileSizeChecker;