"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _public = require("./rest_api_routes/public");
var _existing_indices = require("./rest_api_routes/internal/existing_indices");
var _fields_for = require("./rest_api_routes/internal/fields_for");
var _has_data_views = require("./rest_api_routes/internal/has_data_views");
var _has_es_data = require("./rest_api_routes/internal/has_es_data");
var _fields = require("./rest_api_routes/internal/fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerRoutes({
  http,
  logger,
  getStartServices,
  isRollupsEnabled,
  dataViewRestCounter,
  hasEsDataTimeout
}) {
  const router = http.createRouter();
  _public.routes.forEach(route => route(router, getStartServices, dataViewRestCounter));
  (0, _existing_indices.registerExistingIndicesPath)(router);
  (0, _fields_for.registerFieldForWildcard)(router, getStartServices, isRollupsEnabled);
  (0, _fields.registerFields)(router, getStartServices, isRollupsEnabled);
  (0, _has_data_views.registerHasDataViewsRoute)(router);
  (0, _has_es_data.registerHasEsDataRoute)(router, logger, hasEsDataTimeout);
}