"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerExistingIndicesPath = exports.parseIndices = exports.handler = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../constants");
var _ = require("../..");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Accepts one of the following:
 * 1. An array of field names
 * 2. A JSON-stringified array of field names
 * 3. A single field name (not comma-separated)
 * @returns an array of indices
 * @param indices
 */
const parseIndices = indices => {
  if (Array.isArray(indices)) return indices;
  try {
    return JSON.parse(indices);
  } catch (e) {
    if (!indices.includes(',')) return [indices];
    throw new Error('indices should be an array of index aliases, a JSON-stringified array of index aliases, or a single index alias');
  }
};
exports.parseIndices = parseIndices;
const handler = async (ctx, req, res) => {
  const {
    indices
  } = req.query;
  try {
    const indexArray = parseIndices(indices);
    const core = await ctx.core;
    const elasticsearchClient = core.elasticsearch.client.asCurrentUser;
    const indexPatterns = new _.IndexPatternsFetcher(elasticsearchClient);
    const response = await indexPatterns.getExistingIndices(indexArray);
    return res.ok({
      body: response
    });
  } catch (error) {
    return res.badRequest();
  }
};
exports.handler = handler;
const registerExistingIndicesPath = router => {
  router.versioned.get({
    path: _constants2.EXISTING_INDICES_PATH,
    access: 'internal'
  }).addVersion({
    version: _constants.INITIAL_REST_VERSION_INTERNAL,
    validate: {
      request: {
        query: _configSchema.schema.object({
          indices: _configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])
        })
      },
      response: {
        200: {
          body: () => _configSchema.schema.arrayOf(_configSchema.schema.string())
        }
      }
    }
  }, handler);
};
exports.registerExistingIndicesPath = registerExistingIndicesPath;