"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerResolveIndexRoute = registerResolveIndexRoute;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/kibana-utils-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerResolveIndexRoute(router) {
  router.get({
    path: '/internal/index-pattern-management/resolve_index/{query}',
    validate: {
      params: _configSchema.schema.object({
        query: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        expand_wildcards: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('open'), _configSchema.schema.literal('closed'), _configSchema.schema.literal('hidden'), _configSchema.schema.literal('none')]))
      })
    }
  }, async (context, req, res) => {
    const esClient = (await context.core).elasticsearch.client;
    try {
      const body = await esClient.asCurrentUser.indices.resolveIndex({
        name: req.params.query,
        expand_wildcards: req.query.expand_wildcards || 'open'
      });
      return res.ok({
        body
      });
    } catch (e) {
      if ((e === null || e === void 0 ? void 0 : e.meta.statusCode) === 404) {
        var _e$meta, _e$meta$body, _e$meta$body$error;
        return res.notFound({
          body: {
            message: (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : (_e$meta$body = _e$meta.body) === null || _e$meta$body === void 0 ? void 0 : (_e$meta$body$error = _e$meta$body.error) === null || _e$meta$body$error === void 0 ? void 0 : _e$meta$body$error.reason
          }
        });
      } else {
        throw (0, _server.getKbnServerError)(e);
      }
    }
  });
}