"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsageService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _app_context = require("./app_context");
var _autoops_api = require("./autoops_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataUsageService {
  constructor(dataUsageContext) {
    (0, _defineProperty2.default)(this, "appContextService", void 0);
    (0, _defineProperty2.default)(this, "autoOpsAPIService", void 0);
    this.appContextService = new _app_context.AppContextService(dataUsageContext);
    this.autoOpsAPIService = new _autoops_api.AutoOpsAPIService(this.appContextService);
  }
  getLogger(routeName) {
    return this.appContextService.getLogger().get(routeName);
  }
  async getMetrics({
    from,
    to,
    metricTypes,
    dataStreams
  }) {
    const response = await this.autoOpsAPIService.autoOpsUsageMetricsAPI({
      from,
      to,
      metricTypes,
      dataStreams
    });
    return response.data;
  }
}
exports.DataUsageService = DataUsageService;