"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoOpsAPIService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _https = _interopRequireDefault(require("https"));
var _serverHttpTools = require("@kbn/server-http-tools");
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _axios = _interopRequireDefault(require("axios"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AutoOpsAPIService {
  constructor(appContextService) {
    (0, _defineProperty2.default)(this, "convertCauseErrorsToString", error => {
      if (error.cause instanceof AggregateError) {
        return error.cause.errors.map(e => e.message);
      }
      return error.cause;
    });
    this.appContextService = appContextService;
  }
  async autoOpsUsageMetricsAPI(requestBody) {
    var _apm$currentTransacti, _this$appContextServi, _autoopsConfig$api, _autoopsConfig$api$tl, _autoopsConfig$api2, _autoopsConfig$api2$t, _autoopsConfig$api3, _autoopsConfig$api3$t, _autoopsConfig$api4;
    const logger = this.appContextService.getLogger().get();
    const traceId = (_apm$currentTransacti = _elasticApmNode.default.currentTransaction) === null || _apm$currentTransacti === void 0 ? void 0 : _apm$currentTransacti.traceparent;
    const withRequestIdMessage = message => `${message} [Request Id: ${traceId}]`;
    const errorMetadata = {
      trace: {
        id: traceId
      }
    };
    const autoopsConfig = (_this$appContextServi = this.appContextService.getConfig()) === null || _this$appContextServi === void 0 ? void 0 : _this$appContextServi.autoops;
    if (!autoopsConfig) {
      logger.error('[AutoOps API] Missing autoops configuration', errorMetadata);
      throw new Error('missing autoops configuration');
    }
    logger.debug(`[AutoOps API] Creating autoops agent with TLS cert: ${autoopsConfig !== null && autoopsConfig !== void 0 && (_autoopsConfig$api = autoopsConfig.api) !== null && _autoopsConfig$api !== void 0 && (_autoopsConfig$api$tl = _autoopsConfig$api.tls) !== null && _autoopsConfig$api$tl !== void 0 && _autoopsConfig$api$tl.certificate ? '[REDACTED]' : 'undefined'} and TLS key: ${autoopsConfig !== null && autoopsConfig !== void 0 && (_autoopsConfig$api2 = autoopsConfig.api) !== null && _autoopsConfig$api2 !== void 0 && (_autoopsConfig$api2$t = _autoopsConfig$api2.tls) !== null && _autoopsConfig$api2$t !== void 0 && _autoopsConfig$api2$t.key ? '[REDACTED]' : 'undefined'}
      and TLS ca: ${autoopsConfig !== null && autoopsConfig !== void 0 && (_autoopsConfig$api3 = autoopsConfig.api) !== null && _autoopsConfig$api3 !== void 0 && (_autoopsConfig$api3$t = _autoopsConfig$api3.tls) !== null && _autoopsConfig$api3$t !== void 0 && _autoopsConfig$api3$t.ca ? '[REDACTED]' : 'undefined'}`);
    const tlsConfig = this.createTlsConfig(autoopsConfig);
    const requestConfig = {
      url: (_autoopsConfig$api4 = autoopsConfig.api) === null || _autoopsConfig$api4 === void 0 ? void 0 : _autoopsConfig$api4.url,
      data: requestBody,
      method: 'POST',
      headers: {
        'Content-type': 'application/json',
        'X-Request-ID': traceId
      },
      httpsAgent: new _https.default.Agent({
        rejectUnauthorized: tlsConfig.rejectUnauthorized,
        cert: tlsConfig.certificate,
        key: tlsConfig.key,
        ca: tlsConfig.certificateAuthorities
      })
    };
    const cloudSetup = this.appContextService.getCloud();
    if (!(cloudSetup !== null && cloudSetup !== void 0 && cloudSetup.isServerlessEnabled)) {
      requestConfig.data.stack_version = this.appContextService.getKibanaVersion();
    }
    const requestConfigDebugStatus = this.createRequestConfigDebug(requestConfig);
    logger.debug(`[AutoOps API] Creating autoops agent with request config ${requestConfigDebugStatus}`);
    const errorMetadataWithRequestConfig = {
      ...errorMetadata,
      http: {
        request: {
          id: traceId,
          body: requestConfig.data
        }
      }
    };
    const response = await (0, _axios.default)(requestConfig).catch(error => {
      if (!_axios.default.isAxiosError(error)) {
        logger.error(`[AutoOps API] Creating autoops failed with an error ${error} ${requestConfigDebugStatus}`, errorMetadataWithRequestConfig);
        throw new Error(withRequestIdMessage(error.message));
      }
      const errorLogCodeCause = `${error.code}  ${this.convertCauseErrorsToString(error)}`;
      if (error.response) {
        // The request was made and the server responded with a status code and error data
        logger.error(`[AutoOps API] Creating autoops failed because the AutoOps API responding with a status code that falls out of the range of 2xx: ${JSON.stringify(error.response.status)}} ${JSON.stringify(error.response.data)}} ${requestConfigDebugStatus}`, {
          ...errorMetadataWithRequestConfig,
          http: {
            ...errorMetadataWithRequestConfig.http,
            response: {
              status_code: error.response.status,
              body: error.response.data
            }
          }
        });
        throw new Error(withRequestIdMessage(`the AutoOps API could not create the autoops agent`));
      } else if (error.request) {
        // The request was made but no response was received
        logger.error(`[AutoOps API] Creating autoops agent failed while sending the request to the AutoOps API: ${errorLogCodeCause} ${requestConfigDebugStatus}`, errorMetadataWithRequestConfig);
        throw new Error(withRequestIdMessage(`no response received from the AutoOps API`));
      } else {
        // Something happened in setting up the request that triggered an Error
        logger.error(`[AutoOps API] Creating autoops agent failed to be created ${errorLogCodeCause} ${requestConfigDebugStatus}`, errorMetadataWithRequestConfig);
        throw new Error(withRequestIdMessage('the AutoOps API could not create the autoops agent'));
      }
    });
    logger.debug(`[AutoOps API] Created an autoops agent ${response}`);
    return response;
  }
  createTlsConfig(autoopsConfig) {
    var _autoopsConfig$api5, _autoopsConfig$api5$t, _autoopsConfig$api6, _autoopsConfig$api6$t, _autoopsConfig$api7, _autoopsConfig$api7$t;
    return new _serverHttpTools.SslConfig(_serverHttpTools.sslSchema.validate({
      enabled: true,
      certificate: autoopsConfig === null || autoopsConfig === void 0 ? void 0 : (_autoopsConfig$api5 = autoopsConfig.api) === null || _autoopsConfig$api5 === void 0 ? void 0 : (_autoopsConfig$api5$t = _autoopsConfig$api5.tls) === null || _autoopsConfig$api5$t === void 0 ? void 0 : _autoopsConfig$api5$t.certificate,
      key: autoopsConfig === null || autoopsConfig === void 0 ? void 0 : (_autoopsConfig$api6 = autoopsConfig.api) === null || _autoopsConfig$api6 === void 0 ? void 0 : (_autoopsConfig$api6$t = _autoopsConfig$api6.tls) === null || _autoopsConfig$api6$t === void 0 ? void 0 : _autoopsConfig$api6$t.key,
      certificateAuthorities: autoopsConfig === null || autoopsConfig === void 0 ? void 0 : (_autoopsConfig$api7 = autoopsConfig.api) === null || _autoopsConfig$api7 === void 0 ? void 0 : (_autoopsConfig$api7$t = _autoopsConfig$api7.tls) === null || _autoopsConfig$api7$t === void 0 ? void 0 : _autoopsConfig$api7$t.ca
    }));
  }
  createRequestConfigDebug(requestConfig) {
    return JSON.stringify({
      ...requestConfig,
      data: {
        ...requestConfig.data,
        fleet_token: '[REDACTED]'
      },
      httpsAgent: {
        ...requestConfig.httpsAgent,
        options: {
          ...requestConfig.httpsAgent.options,
          cert: requestConfig.httpsAgent.options.cert ? 'REDACTED' : undefined,
          key: requestConfig.httpsAgent.options.key ? 'REDACTED' : undefined,
          ca: requestConfig.httpsAgent.options.ca ? 'REDACTED' : undefined
        }
      }
    });
  }
}
exports.AutoOpsAPIService = AutoOpsAPIService;