"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppContextService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _repoInfo = require("@kbn/repo-info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AppContextService {
  constructor(appContext) {
    (0, _defineProperty2.default)(this, "config$", void 0);
    (0, _defineProperty2.default)(this, "configSubject$", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", _repoInfo.kibanaPackageJson.version);
    (0, _defineProperty2.default)(this, "kibanaBranch", _repoInfo.kibanaPackageJson.branch);
    (0, _defineProperty2.default)(this, "kibanaInstanceId", '');
    (0, _defineProperty2.default)(this, "cloud", void 0);
    (0, _defineProperty2.default)(this, "logFactory", void 0);
    this.cloud = appContext.cloud;
    this.logFactory = appContext.logFactory;
    this.kibanaVersion = appContext.kibanaVersion;
    this.kibanaBranch = appContext.kibanaBranch;
    this.kibanaInstanceId = appContext.kibanaInstanceId;
    if (appContext.config$) {
      this.config$ = appContext.config$;
      const initialValue = appContext.configInitialValue;
      this.configSubject$ = new _rxjs.BehaviorSubject(initialValue);
    }
  }
  stop() {}
  getCloud() {
    return this.cloud;
  }
  getLogger() {
    if (!this.logFactory) {
      throw new Error('Logger not set.');
    }
    return this.logFactory;
  }
  getConfig() {
    var _this$configSubject$;
    return (_this$configSubject$ = this.configSubject$) === null || _this$configSubject$ === void 0 ? void 0 : _this$configSubject$.value;
  }
  getConfig$() {
    return this.config$;
  }
  getKibanaVersion() {
    return this.kibanaVersion;
  }
  getKibanaBranch() {
    return this.kibanaBranch;
  }
  getKibanaInstanceId() {
    return this.kibanaInstanceId;
  }
}
exports.AppContextService = AppContextService;