"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamsHandler = void 0;
var _error_handler = require("../error_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMeteringStats = client => {
  return client.transport.request({
    method: 'GET',
    path: '/_metering/stats'
  });
};
const getDataStreamsHandler = dataUsageService => {
  const logger = dataUsageService.getLogger('dataStreamsRoute');
  return async (context, _, response) => {
    logger.debug('Retrieving user data streams');
    try {
      const core = await context.core;
      const {
        datastreams: meteringStats
      } = await getMeteringStats(core.elasticsearch.client.asSecondaryAuthUser);
      const body = meteringStats.sort((a, b) => b.size_in_bytes - a.size_in_bytes).map(stat => {
        var _stat$size_in_bytes;
        return {
          name: stat.name,
          storageSizeBytes: (_stat$size_in_bytes = stat.size_in_bytes) !== null && _stat$size_in_bytes !== void 0 ? _stat$size_in_bytes : 0
        };
      });
      return response.ok({
        body
      });
    } catch (error) {
      return (0, _error_handler.errorHandler)(logger, response, error);
    }
  };
};
exports.getDataStreamsHandler = getDataStreamsHandler;