"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDataStreamsRoute = void 0;
var _rest_types = require("../../../common/rest_types");
var _common = require("../../../common");
var _data_streams_handler = require("./data_streams_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerDataStreamsRoute = (router, dataUsageService) => {
  router.versioned.get({
    access: 'internal',
    path: _common.DATA_USAGE_DATA_STREAMS_API_ROUTE
  }).addVersion({
    version: '1',
    validate: {
      request: {},
      response: {
        200: _rest_types.DataStreamsResponseSchema
      }
    }
  }, (0, _data_streams_handler.getDataStreamsHandler)(dataUsageService));
};
exports.registerDataStreamsRoute = registerDataStreamsRoute;