"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsagePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _config = require("./config");
var _routes = require("./routes");
var _common = require("../common");
var _services = require("./services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataUsagePlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "dataUsageContext", void 0);
    const serverConfig = (0, _config.createConfig)(context);
    this.logger = context.logger.get();
    this.logger.debug('data usage plugin initialized');
    this.dataUsageContext = {
      config$: context.config.create(),
      configInitialValue: context.config.get(),
      logFactory: context.logger,
      get serverConfig() {
        return serverConfig;
      },
      kibanaVersion: context.env.packageInfo.version,
      kibanaBranch: context.env.packageInfo.branch,
      kibanaInstanceId: context.env.instanceUuid
    };
  }
  setup(coreSetup, pluginsSetup) {
    this.logger.debug('data usage plugin setup');
    const dataUsageService = new _services.DataUsageService(this.dataUsageContext);
    pluginsSetup.features.registerElasticsearchFeature({
      id: _common.PLUGIN_ID,
      management: {
        data: [_common.PLUGIN_ID]
      },
      privileges: [{
        requiredClusterPrivileges: ['monitor'],
        ui: []
      }]
    });
    const router = coreSetup.http.createRouter();
    (0, _routes.registerDataUsageRoutes)(router, dataUsageService);
    return {};
  }
  start(_coreStart, _pluginsStart) {
    return {};
  }
  stop() {
    this.logger.debug('Stopping data usage plugin');
  }
}
exports.DataUsagePlugin = DataUsagePlugin;