"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfig = exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  autoops: _configSchema.schema.maybe(_configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    api: _configSchema.schema.maybe(_configSchema.schema.object({
      url: _configSchema.schema.maybe(_configSchema.schema.uri({
        scheme: ['http', 'https']
      })),
      tls: _configSchema.schema.maybe(_configSchema.schema.object({
        certificate: _configSchema.schema.maybe(_configSchema.schema.string()),
        key: _configSchema.schema.maybe(_configSchema.schema.string()),
        ca: _configSchema.schema.maybe(_configSchema.schema.string())
      }))
    }))
  }))
});
const createConfig = context => {
  const pluginConfig = context.config.get();
  return {
    ...pluginConfig
  };
};
exports.createConfig = createConfig;