"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDataUsageMetrics = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("../../common");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDataUsageMetrics = (body, options = {}) => {
  const http = (0, _use_kibana.useKibanaContextForPlugin)().services.http;
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-data-usage-metrics', body],
    ...options,
    keepPreviousData: true,
    queryFn: async ({
      signal
    }) => {
      return http.post(_common.DATA_USAGE_METRICS_API_ROUTE, {
        signal,
        version: '1',
        body: JSON.stringify({
          from: body.from,
          to: body.to,
          metricTypes: body.metricTypes,
          dataStreams: body.dataStreams
        })
      });
    },
    onError: error => {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.dataUsage.getMetrics.addFailure.toast.title', {
          defaultMessage: 'Error getting usage metrics'
        }),
        text: error.message
      });
    }
  });
};
exports.useGetDataUsageMetrics = useGetDataUsageMetrics;