"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDataUsageDataStreams = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _common = require("../../common");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGING_PARAMS = Object.freeze({
  default: 50,
  all: 10000
});
const useGetDataUsageDataStreams = ({
  selectedDataStreams,
  options = {
    enabled: false
  }
}) => {
  const http = (0, _use_kibana.useKibanaContextForPlugin)().services.http;
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-data-usage-data-streams'],
    ...options,
    keepPreviousData: true,
    queryFn: async () => {
      const dataStreamsResponse = await http.get(_common.DATA_USAGE_DATA_STREAMS_API_ROUTE, {
        version: '1'
        // query: {},
      });
      const augmentedDataStreamsBasedOnSelectedItems = dataStreamsResponse.reduce((acc, ds) => {
        const item = {
          name: ds.name,
          storageSizeBytes: ds.storageSizeBytes,
          selected: ds.selected
        };
        if (selectedDataStreams !== null && selectedDataStreams !== void 0 && selectedDataStreams.includes(ds.name)) {
          acc.selected.push({
            ...item,
            selected: true
          });
        } else {
          acc.rest.push({
            ...item,
            selected: false
          });
        }
        return acc;
      }, {
        selected: [],
        rest: []
      });
      let selectedDataStreamsCount = 0;
      if (selectedDataStreams) {
        selectedDataStreamsCount = selectedDataStreams.length;
      }
      return [...augmentedDataStreamsBasedOnSelectedItems.selected, ...augmentedDataStreamsBasedOnSelectedItems.rest].slice(0, selectedDataStreamsCount >= PAGING_PARAMS.default ? selectedDataStreamsCount + 10 : PAGING_PARAMS.default);
    },
    onError: error => {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.dataUsage.getDataStreams.addFailure.toast.title', {
          defaultMessage: 'Error getting data streams'
        }),
        text: error.message
      });
    }
  });
};
exports.useGetDataUsageDataStreams = useGetDataUsageDataStreams;