"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UX_LABELS = exports.FILTER_NAMES = exports.DATA_USAGE_PAGE = exports.CHART_TITLES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_NAMES = exports.FILTER_NAMES = Object.freeze({
  metricTypes: _i18n.i18n.translate('xpack.dataUsage.metrics.filter.metricTypes', {
    defaultMessage: 'Metric types'
  }),
  dataStreams: _i18n.i18n.translate('xpack.dataUsage.metrics.filter.dataStreams', {
    defaultMessage: 'Data streams'
  })
});
const CHART_TITLES = exports.CHART_TITLES = Object.freeze({
  ingest_rate: _i18n.i18n.translate('xpack.dataUsage.charts.ingestedMax', {
    defaultMessage: 'Data Ingested'
  }),
  storage_retained: _i18n.i18n.translate('xpack.dataUsage.charts.retainedMax', {
    defaultMessage: 'Data Retained in Storage'
  })
});
const DATA_USAGE_PAGE = exports.DATA_USAGE_PAGE = Object.freeze({
  title: _i18n.i18n.translate('xpack.dataUsage.name', {
    defaultMessage: 'Data Usage'
  }),
  subTitle: _i18n.i18n.translate('xpack.dataUsage.pageSubtitle', {
    defaultMessage: 'Monitor data ingested and retained by data streams.'
  })
});
const UX_LABELS = exports.UX_LABELS = Object.freeze({
  filterClearAll: _i18n.i18n.translate('xpack.dataUsage.metrics.filter.clearAll', {
    defaultMessage: 'Clear all'
  }),
  filterSearchPlaceholder: filterName => _i18n.i18n.translate('xpack.dataUsage.metrics.filter.searchPlaceholder', {
    defaultMessage: 'Search {filterName}',
    values: {
      filterName
    }
  }),
  filterEmptyMessage: filterName => _i18n.i18n.translate('xpack.dataUsage.metrics.filter.emptyMessage', {
    defaultMessage: 'No {filterName} available',
    values: {
      filterName
    }
  })
});