"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDateRangePicker = exports.DEFAULT_DATE_RANGE_OPTIONS = void 0;
var _react = require("react");
var _use_charts_url_params = require("./use_charts_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_RANGE_OPTIONS = exports.DEFAULT_DATE_RANGE_OPTIONS = Object.freeze({
  autoRefreshOptions: {
    enabled: false,
    duration: 10000
  },
  startDate: 'now-24h/h',
  endDate: 'now',
  recentlyUsedDateRanges: []
});
const useDateRangePicker = () => {
  const {
    setUrlDateRangeFilter,
    startDate: startDateFromUrl,
    endDate: endDateFromUrl
  } = (0, _use_charts_url_params.useDataUsageMetricsUrlParams)();
  const [dateRangePickerState, setDateRangePickerState] = (0, _react.useState)({
    ...DEFAULT_DATE_RANGE_OPTIONS,
    startDate: startDateFromUrl !== null && startDateFromUrl !== void 0 ? startDateFromUrl : DEFAULT_DATE_RANGE_OPTIONS.startDate,
    endDate: endDateFromUrl !== null && endDateFromUrl !== void 0 ? endDateFromUrl : DEFAULT_DATE_RANGE_OPTIONS.endDate
  });
  const updateUsageMetricsDateRanges = (0, _react.useCallback)(({
    start,
    end
  }) => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      startDate: start,
      endDate: end
    }));
  }, [setDateRangePickerState]);
  const updateUsageMetricsRecentlyUsedDateRanges = (0, _react.useCallback)(recentlyUsedDateRanges => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      recentlyUsedDateRanges
    }));
  }, [setDateRangePickerState]);

  // handle refresh timer update
  const onRefreshChange = (0, _react.useCallback)(evt => {
    setDateRangePickerState(prevState => ({
      ...prevState,
      autoRefreshOptions: {
        enabled: !evt.isPaused,
        duration: evt.refreshInterval
      }
    }));
  }, [setDateRangePickerState]);

  // handle manual time change on date picker
  const onTimeChange = (0, _react.useCallback)(({
    start: newStart,
    end: newEnd
  }) => {
    // update date ranges
    updateUsageMetricsDateRanges({
      start: newStart,
      end: newEnd
    });

    // update recently used date ranges
    const newRecentlyUsedDateRanges = [{
      start: newStart,
      end: newEnd
    }, ...dateRangePickerState.recentlyUsedDateRanges.filter(recentlyUsedRange => !(recentlyUsedRange.start === newStart && recentlyUsedRange.end === newEnd)).slice(0, 9)];
    updateUsageMetricsRecentlyUsedDateRanges(newRecentlyUsedDateRanges);
    setUrlDateRangeFilter({
      startDate: newStart,
      endDate: newEnd
    });
  }, [dateRangePickerState.recentlyUsedDateRanges, setUrlDateRangeFilter, updateUsageMetricsDateRanges, updateUsageMetricsRecentlyUsedDateRanges]);
  return {
    dateRangePickerState,
    onRefreshChange,
    onTimeChange
  };
};
exports.useDateRangePicker = useDateRangePicker;