"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartsFilter = void 0;
var _react = require("react");
var _rest_types = require("../../../common/rest_types");
var _use_charts_url_params = require("./use_charts_url_params");
var _format_bytes = require("../../utils/format_bytes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useChartsFilter = ({
  filterOptions
}) => {
  var _filterOptions$option;
  const {
    dataStreams: selectedDataStreamsFromUrl,
    setUrlMetricTypesFilter,
    setUrlDataStreamsFilter
  } = (0, _use_charts_url_params.useDataUsageMetricsUrlParams)();
  const isMetricTypesFilter = filterOptions.filterName === 'metricTypes';
  const isDataStreamsFilter = filterOptions.filterName === 'dataStreams';

  // track the state of selected data streams via URL
  //  when the page is loaded via selected data streams on URL
  const [areDataStreamsSelectedOnMount, setAreDataStreamsSelectedOnMount] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (selectedDataStreamsFromUrl && selectedDataStreamsFromUrl.length > 0) {
      setAreDataStreamsSelectedOnMount(true);
    }
    // don't sync with changes to further selectedDataStreamsFromUrl
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // filter options
  const [items, setItems] = (0, _react.useState)(isMetricTypesFilter ? _rest_types.METRIC_TYPE_VALUES.map(metricType => ({
    key: metricType,
    label: _rest_types.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP[metricType],
    checked: (0, _rest_types.isDefaultMetricType)(metricType) ? 'on' : undefined,
    // default metrics are selected by default
    disabled: (0, _rest_types.isDefaultMetricType)(metricType),
    'data-test-subj': `${filterOptions.filterName}-filter-option`
  })) : isDataStreamsFilter && !!filterOptions.options.length ? (_filterOptions$option = filterOptions.options) === null || _filterOptions$option === void 0 ? void 0 : _filterOptions$option.map(filterOption => {
    var _filterOptions$append, _filterOptions$append2;
    return {
      key: filterOption,
      label: filterOption,
      append: (0, _format_bytes.formatBytes)((_filterOptions$append = (_filterOptions$append2 = filterOptions.appendOptions) === null || _filterOptions$append2 === void 0 ? void 0 : _filterOptions$append2[filterOption]) !== null && _filterOptions$append !== void 0 ? _filterOptions$append : 0),
      checked: selectedDataStreamsFromUrl ? selectedDataStreamsFromUrl.includes(filterOption) ? 'on' : undefined : 'on',
      'data-test-subj': `${filterOptions.filterName}-filter-option`
    };
  }) : []);
  const hasActiveFilters = (0, _react.useMemo)(() => !!items.find(item => item.checked === 'on'), [items]);
  const numActiveFilters = (0, _react.useMemo)(() => items.filter(item => item.checked === 'on').length, [items]);
  const numFilters = (0, _react.useMemo)(() => items.filter(item => item.key && item.checked !== 'on').length, [items]);
  return {
    areDataStreamsSelectedOnMount,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreDataStreamsSelectedOnMount,
    setUrlMetricTypesFilter,
    setUrlDataStreamsFilter
  };
};
exports.useChartsFilter = useChartsFilter;