"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _dataset_quality_link = require("./dataset_quality_link");
var _use_kibana = require("../../utils/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LegendAction = exports.LegendAction = /*#__PURE__*/_react.default.memo(({
  label,
  idx,
  popoverOpen,
  togglePopover
}) => {
  const uniqueStreamName = `${idx}-${label}`;
  const {
    services: {
      share: {
        url: {
          locators
        }
      },
      application: {
        capabilities
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const hasDataSetQualityFeature = !!(capabilities !== null && capabilities !== void 0 && capabilities.data_quality);
  const hasIndexManagementFeature = !!(capabilities !== null && capabilities !== void 0 && capabilities.index_management);
  const onClickIndexManagement = (0, _react.useCallback)(async () => {
    const locator = locators.get('INDEX_MANAGEMENT_LOCATOR_ID');
    if (locator) {
      await locator.navigate({
        page: 'data_streams_details',
        dataStreamName: label
      });
    }
    togglePopover(null); // Close the popover after action
  }, [label, locators, togglePopover]);
  const onCopyDataStreamName = (0, _react.useCallback)(() => {
    navigator.clipboard.writeText(label);
    togglePopover(null); // Close popover after copying
  }, [label, togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "boxesHorizontal",
      "aria-label": "Open data stream actions",
      onClick: () => togglePopover(uniqueStreamName)
    }))),
    isOpen: popoverOpen === uniqueStreamName,
    closePopover: () => togglePopover(null),
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    label: "Copy data stream name",
    onClick: onCopyDataStreamName
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), hasIndexManagementFeature && /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    label: "Manage data stream",
    onClick: onClickIndexManagement
  }), hasDataSetQualityFeature && /*#__PURE__*/_react.default.createElement(_dataset_quality_link.DatasetQualityLink, {
    dataStreamName: label
  }))));
});