"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsFilter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _rest_types = require("../../../../common/rest_types");
var _translations = require("../../translations");
var _charts_filter_popover = require("./charts_filter_popover");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSearchPlaceholder = filterName => {
  if (filterName === 'dataStreams') {
    return _translations.UX_LABELS.filterSearchPlaceholder('data streams');
  }
  return _translations.UX_LABELS.filterSearchPlaceholder('metric types');
};
const ChartsFilter = exports.ChartsFilter = /*#__PURE__*/(0, _react.memo)(({
  filterOptions: {
    filterName,
    options,
    appendOptions,
    selectedOptions,
    onChangeFilterOptions,
    isFilterLoading = false
  },
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isMetricsFilter = filterName === 'metricTypes';
  const isDataStreamsFilter = filterName === 'dataStreams';

  // popover states and handlers
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onPopoverButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [setIsPopoverOpen, isPopoverOpen]);
  const onClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const {
    areDataStreamsSelectedOnMount,
    items,
    setItems,
    hasActiveFilters,
    numActiveFilters,
    numFilters,
    setAreDataStreamsSelectedOnMount,
    setUrlDataStreamsFilter,
    setUrlMetricTypesFilter
  } = (0, _hooks.useChartsFilter)({
    filterOptions: {
      filterName,
      options,
      appendOptions,
      selectedOptions,
      onChangeFilterOptions,
      isFilterLoading
    }
  });

  // track popover state to pin selected options
  const wasPopoverOpen = (0, _react.useRef)(isPopoverOpen);

  // compute if selected dataStreams should be pinned
  const shouldPinSelectedDataStreams = (0, _react.useCallback)((isNotChangingOptions = true) => {
    // case 1: when no dataStreams are selected initially
    return isNotChangingOptions && wasPopoverOpen.current && isPopoverOpen && filterName === 'dataStreams';
  }, [filterName, isPopoverOpen]);

  // augmented options based on the dataStreams filter
  const sortedHostsFilterOptions = (0, _react.useMemo)(() => {
    if (shouldPinSelectedDataStreams() || areDataStreamsSelectedOnMount) {
      // pin checked items to the top
      return (0, _fp.orderBy)('checked', 'asc', items);
    }
    // return options as are for other filters
    return items;
  }, [areDataStreamsSelectedOnMount, shouldPinSelectedDataStreams, items]);
  const isSearchable = (0, _react.useMemo)(() => !isMetricsFilter, [isMetricsFilter]);
  const onOptionsChange = (0, _react.useCallback)(newOptions => {
    const optionItemsToSet = newOptions.map(option => option);
    const currChecks = optionItemsToSet.filter(option => option.checked === 'on');

    // don't update filter state if trying to uncheck all options
    if (currChecks.length < 1) {
      return;
    }

    // update filter UI options state
    setItems(optionItemsToSet);

    // compute a selected list of options
    const selectedItems = newOptions.reduce((acc, curr) => {
      if (curr.checked === 'on' && curr.key) {
        acc.push(curr.key);
      }
      return acc;
    }, []);

    // update URL params
    if (isMetricsFilter) {
      setUrlMetricTypesFilter(selectedItems.map(item => _rest_types.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP[item]).join());
    } else if (isDataStreamsFilter) {
      setUrlDataStreamsFilter(selectedItems.join());
    }
    // reset shouldPinSelectedDataStreams, setAreDataStreamsSelectedOnMount
    shouldPinSelectedDataStreams(false);
    setAreDataStreamsSelectedOnMount(false);
    onChangeFilterOptions(selectedItems);
  }, [setItems, isMetricsFilter, isDataStreamsFilter, shouldPinSelectedDataStreams, setAreDataStreamsSelectedOnMount, onChangeFilterOptions, setUrlMetricTypesFilter, setUrlDataStreamsFilter]);
  (0, _react.useEffect)(() => {
    return () => {
      wasPopoverOpen.current = isPopoverOpen;
    };
  }, [isPopoverOpen, wasPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_charts_filter_popover.ChartsFilterPopover, {
    closePopover: onClosePopover,
    filterName: filterName,
    hasActiveFilters: hasActiveFilters,
    isPopoverOpen: isPopoverOpen,
    numActiveFilters: numActiveFilters,
    numFilters: numFilters,
    onButtonClick: onPopoverButtonClick,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": `${filterName}`,
    emptyMessage: _translations.UX_LABELS.filterEmptyMessage(filterName),
    isLoading: isFilterLoading,
    onChange: onOptionsChange,
    options: sortedHostsFilterOptions,
    searchable: isSearchable ? true : undefined,
    searchProps: {
      placeholder: getSearchPlaceholder(filterName),
      compressed: true
    }
  }, (list, search) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: 300
      },
      "data-test-subj": getTestId(`${filterName}-filter-popoverList`)
    }, isSearchable && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      "data-test-subj": getTestId(`${filterName}-filter-search`),
      paddingSize: "s"
    }, search), list);
  }));
});
ChartsFilter.displayName = 'ChartsFilter';