"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsageMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _charts = require("./charts");
var _use_breadcrumbs = require("../../utils/use_breadcrumbs");
var _use_kibana = require("../../utils/use_kibana");
var _common = require("../../../common");
var _use_get_usage_metrics = require("../../hooks/use_get_usage_metrics");
var _use_charts_url_params = require("../hooks/use_charts_url_params");
var _use_date_picker = require("../hooks/use_date_picker");
var _rest_types = require("../../../common/rest_types");
var _charts_filters = require("./filters/charts_filters");
var _use_get_data_streams = require("../../hooks/use_get_data_streams");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiItemCss = (0, _react2.css)`
  width: 100%;
`;
const FlexItemWithCss = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: EuiItemCss
}, children);
const DataUsageMetrics = () => {
  const {
    services: {
      chrome,
      appParams
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _common.PLUGIN_NAME
  }], appParams, chrome);
  const {
    metricTypes: metricTypesFromUrl,
    dataStreams: dataStreamsFromUrl,
    startDate: startDateFromUrl,
    endDate: endDateFromUrl,
    setUrlMetricTypesFilter,
    setUrlDataStreamsFilter,
    setUrlDateRangeFilter
  } = (0, _use_charts_url_params.useDataUsageMetricsUrlParams)();
  const {
    data: dataStreams,
    isFetching: isFetchingDataStreams
  } = (0, _use_get_data_streams.useGetDataUsageDataStreams)({
    selectedDataStreams: dataStreamsFromUrl,
    options: {
      enabled: true
    }
  });
  const [metricsFilters, setMetricsFilters] = (0, _react.useState)({
    metricTypes: [..._rest_types.DEFAULT_METRIC_TYPES],
    dataStreams: [],
    from: _use_date_picker.DEFAULT_DATE_RANGE_OPTIONS.startDate,
    to: _use_date_picker.DEFAULT_DATE_RANGE_OPTIONS.endDate
  });
  (0, _react.useEffect)(() => {
    if (!metricTypesFromUrl) {
      setUrlMetricTypesFilter(metricsFilters.metricTypes.join(','));
    }
    if (!dataStreamsFromUrl && dataStreams) {
      setUrlDataStreamsFilter(dataStreams.map(ds => ds.name).join(','));
    }
    if (!startDateFromUrl || !endDateFromUrl) {
      setUrlDateRangeFilter({
        startDate: metricsFilters.from,
        endDate: metricsFilters.to
      });
    }
  }, [dataStreams, dataStreamsFromUrl, endDateFromUrl, metricTypesFromUrl, metricsFilters.dataStreams, metricsFilters.from, metricsFilters.metricTypes, metricsFilters.to, setUrlDataStreamsFilter, setUrlDateRangeFilter, setUrlMetricTypesFilter, startDateFromUrl]);
  (0, _react.useEffect)(() => {
    setMetricsFilters(prevState => ({
      ...prevState,
      metricTypes: metricTypesFromUrl !== null && metricTypesFromUrl !== void 0 && metricTypesFromUrl.length ? metricTypesFromUrl : prevState.metricTypes,
      dataStreams: dataStreamsFromUrl !== null && dataStreamsFromUrl !== void 0 && dataStreamsFromUrl.length ? dataStreamsFromUrl : prevState.dataStreams
    }));
  }, [metricTypesFromUrl, dataStreamsFromUrl]);
  const {
    dateRangePickerState,
    onRefreshChange,
    onTimeChange
  } = (0, _use_date_picker.useDateRangePicker)();
  const {
    data,
    isFetching,
    isFetched,
    refetch: refetchDataUsageMetrics
  } = (0, _use_get_usage_metrics.useGetDataUsageMetrics)({
    ...metricsFilters,
    from: dateRangePickerState.startDate,
    to: dateRangePickerState.endDate
  }, {
    retry: false,
    enabled: !!metricsFilters.dataStreams.length
  });
  const onRefresh = (0, _react.useCallback)(() => {
    refetchDataUsageMetrics();
  }, [refetchDataUsageMetrics]);
  const onChangeDataStreamsFilter = (0, _react.useCallback)(selectedDataStreams => {
    setMetricsFilters(prevState => ({
      ...prevState,
      dataStreams: selectedDataStreams
    }));
  }, [setMetricsFilters]);
  const onChangeMetricTypesFilter = (0, _react.useCallback)(selectedMetricTypes => {
    setMetricsFilters(prevState => ({
      ...prevState,
      metricTypes: selectedMetricTypes
    }));
  }, [setMetricsFilters]);
  const filterOptions = (0, _react.useMemo)(() => {
    const dataStreamsOptions = dataStreams === null || dataStreams === void 0 ? void 0 : dataStreams.reduce((acc, ds) => {
      acc[ds.name] = ds.storageSizeBytes;
      return acc;
    }, {});
    return {
      dataStreams: {
        filterName: 'dataStreams',
        options: dataStreamsOptions ? Object.keys(dataStreamsOptions) : metricsFilters.dataStreams,
        appendOptions: dataStreamsOptions,
        selectedOptions: metricsFilters.dataStreams,
        onChangeFilterOptions: onChangeDataStreamsFilter,
        isFilterLoading: isFetchingDataStreams
      },
      metricTypes: {
        filterName: 'metricTypes',
        options: metricsFilters.metricTypes,
        onChangeFilterOptions: onChangeMetricTypesFilter
      }
    };
  }, [dataStreams, isFetchingDataStreams, metricsFilters.dataStreams, metricsFilters.metricTypes, onChangeDataStreamsFilter, onChangeMetricTypesFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(FlexItemWithCss, null, /*#__PURE__*/_react.default.createElement(_charts_filters.ChartFilters, {
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isFetchingDataStreams,
    onClick: refetchDataUsageMetrics,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    filterOptions: filterOptions,
    showMetricsTypesFilter: false
  })), /*#__PURE__*/_react.default.createElement(FlexItemWithCss, null, isFetched && data !== null && data !== void 0 && data.metrics ? /*#__PURE__*/_react.default.createElement(_charts.Charts, {
    data: data
  }) : isFetching ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, null) : null));
};
exports.DataUsageMetrics = DataUsageMetrics;