"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chartKeyToTitleMap = exports.ChartPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _legend_action = require("./legend_action");
var _format_bytes = require("../../utils/format_bytes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Remove this when we have a title for each metric type

const chartKeyToTitleMap = exports.chartKeyToTitleMap = {
  ingest_rate: _i18n.i18n.translate('xpack.dataUsage.charts.ingestedMax', {
    defaultMessage: 'Data Ingested'
  }),
  storage_retained: _i18n.i18n.translate('xpack.dataUsage.charts.retainedMax', {
    defaultMessage: 'Data Retained in Storage'
  })
};
const ChartPanel = ({
  metricType,
  series,
  idx,
  popoverOpen,
  togglePopover
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const chartTimestamps = series.flatMap(stream => stream.data.map(d => d.x));
  const [minTimestamp, maxTimestamp] = [Math.min(...chartTimestamps), Math.max(...chartTimestamps)];
  const tickFormat = (0, _react.useMemo)(() => (0, _charts.niceTimeFormatter)([minTimestamp, maxTimestamp]), [minTimestamp, maxTimestamp]);
  const renderLegendAction = (0, _react.useCallback)(({
    label
  }) => {
    return /*#__PURE__*/_react.default.createElement(_legend_action.LegendAction, {
      label: label,
      idx: idx,
      popoverOpen: popoverOpen,
      togglePopover: togglePopover
    });
  }, [idx, popoverOpen, togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: metricType
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, chartKeyToTitleMap[metricType] || metricType)), /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 200
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme.colorMode === 'DARK' ? _charts.DARK_THEME : _charts.LIGHT_THEME,
    showLegend: true,
    legendPosition: "right",
    xDomain: {
      min: minTimestamp,
      max: maxTimestamp
    },
    legendAction: renderLegendAction
  }), series.map((stream, streamIdx) => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: streamIdx,
    id: `${metricType}-${stream.name}`,
    name: stream.name,
    data: stream.data,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    stackAccessors: ['x']
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: tickFormat,
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    gridLine: {
      visible: true
    },
    tickFormat: d => (0, _format_bytes.formatBytes)(d)
  }))));
};
exports.ChartPanel = ChartPanel;